/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.FileStoreUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FileStoreUtilTest {
    int diff = RandomUtil.getPositiveInt();
    String pathPrefix = "target/test-output/fs" + this.diff + "/";

    @Test
    public void filesOnSameFolderShouldBeOnTheSameFileStore() throws RolloverFailure, IOException {
        if (!EnvUtil.isJDK7OrHigher()) {
            return;
        }
        File file = new File(this.pathPrefix);
        File file2 = new File(this.pathPrefix + "filesOnSameFolderShouldBeOnTheSameFileStore");
        FileUtil.createMissingParentDirectories((File)file2);
        file2.createNewFile();
        Assert.assertTrue((boolean)FileStoreUtil.areOnSameFileStore((File)file, (File)file2));
    }

    @Ignore
    @Test
    public void manual_filesOnDifferentVolumesShouldBeDetectedAsSuch() throws RolloverFailure {
        if (!EnvUtil.isJDK7OrHigher()) {
            return;
        }
        File file = new File("c:/tmp/");
        File file2 = new File("d:/");
        Assert.assertFalse((boolean)FileStoreUtil.areOnSameFileStore((File)file, (File)file2));
    }
}

