/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.util.Date;
import junit.framework.TestCase;

public class RollingCalendarTest
extends TestCase {
    public RollingCalendarTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPeriodicity() {
        RollingCalendar rollingCalendar = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_SECOND, (Object)rollingCalendar.computePeriodicityType("yyyy-MM-dd_HH_mm_ss"));
        rollingCalendar = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_MINUTE, (Object)rollingCalendar.computePeriodicityType("yyyy-MM-dd_HH_mm"));
        rollingCalendar = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_HOUR, (Object)rollingCalendar.computePeriodicityType("yyyy-MM-dd_HH"));
        rollingCalendar = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_DAY, (Object)rollingCalendar.computePeriodicityType("yyyy-MM-dd"));
        rollingCalendar = new RollingCalendar();
        RollingCalendarTest.assertEquals((Object)PeriodicityType.TOP_OF_MONTH, (Object)rollingCalendar.computePeriodicityType("yyyy-MM"));
    }

    public void testVaryingNumberOfHourlyPeriods() {
        RollingCalendar rollingCalendar = new RollingCalendar();
        rollingCalendar.init("yyyy-MM-dd_HH");
        long l = 3600000L;
        for (int i = 100; i > -100; --i) {
            long l2 = 1223325293589L;
            Date date = rollingCalendar.getRelativeDate(new Date(l2), i);
            long l3 = l2 - l2 % l + (long)i * l;
            RollingCalendarTest.assertEquals((long)l3, (long)date.getTime());
        }
    }

    public void testVaryingNumberOfDailyPeriods() {
        RollingCalendar rollingCalendar = new RollingCalendar();
        rollingCalendar.init("yyyy-MM-dd");
        for (int i = 20; i > -100; --i) {
            long l = 1223325293589L;
            Date date = new Date(l);
            Date date2 = rollingCalendar.getRelativeDate(date, i);
            long l2 = rollingCalendar.getTimeZone().getRawOffset() + rollingCalendar.getTimeZone().getDSTSavings();
            long l3 = l - l % 86400000L - l2;
            long l4 = l3 + (long)i * 86400000L;
            RollingCalendarTest.assertEquals((String)("p=" + i), (long)l4, (long)date2.getTime());
        }
    }
}

