/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.sift.AppenderFactory;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppenderTrackerTest {
    Context context = new ContextBase();
    ListAppenderFactory listAppenderFactory = new ListAppenderFactory();
    int diff = RandomUtil.getPositiveInt();
    AppenderTracker<Object> appenderTracker = new AppenderTracker(this.context, (AppenderFactory)this.listAppenderFactory);
    String key = "k-" + this.diff;
    long now = 3000L;

    @Before
    public void setUp() {
    }

    @Test
    public void removeStaleComponentsShouldNotBomb() {
        this.appenderTracker.removeStaleComponents(this.now);
        junit.framework.Assert.assertEquals((int)0, (int)this.appenderTracker.getComponentCount());
    }

    @Test
    public void findingTheInexistentShouldNotBomb() {
        junit.framework.Assert.assertNull((Object)this.appenderTracker.find(this.key));
        this.now += 1800001L;
        this.appenderTracker.removeStaleComponents(this.now);
        junit.framework.Assert.assertNull((Object)this.appenderTracker.find(this.key));
    }

    @Test
    public void smoke() {
        Appender appender = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        junit.framework.Assert.assertTrue((boolean)appender.isStarted());
        this.now += 1800001L;
        this.appenderTracker.removeStaleComponents(this.now);
        junit.framework.Assert.assertFalse((boolean)appender.isStarted());
        junit.framework.Assert.assertNull((Object)this.appenderTracker.find(this.key));
    }

    @Test
    public void endOfLivedAppendersShouldBeRemovedAfterLingeringTimeout() {
        Appender appender = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        this.appenderTracker.endOfLife(this.key);
        this.now += 10001L;
        this.appenderTracker.removeStaleComponents(this.now);
        junit.framework.Assert.assertFalse((boolean)appender.isStarted());
        appender = (Appender)this.appenderTracker.find(this.key);
        junit.framework.Assert.assertNull((Object)appender);
    }

    @Test
    public void endOfLivedAppenderShouldBeAvailableDuringLingeringPeriod() {
        Appender appender = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        this.appenderTracker.endOfLife(this.key);
        this.appenderTracker.removeStaleComponents(this.now);
        Appender appender2 = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        junit.framework.Assert.assertTrue((boolean)appender2.isStarted());
        junit.framework.Assert.assertTrue((appender == appender2 ? 1 : 0) != 0);
        this.now += 10001L;
        this.appenderTracker.removeStaleComponents(this.now);
        junit.framework.Assert.assertFalse((boolean)appender.isStarted());
        appender = (Appender)this.appenderTracker.find(this.key);
        junit.framework.Assert.assertNull((Object)appender);
    }

    @Test
    public void trackerShouldHonorMaxComponentsParameter() {
        ArrayList<Appender> arrayList = new ArrayList<Appender>();
        int n = 10;
        this.appenderTracker.setMaxComponents(n);
        for (int i = 0; i < n + 1; ++i) {
            Appender appender = (Appender)this.appenderTracker.getOrCreate(this.key + "-" + i, this.now++);
            arrayList.add(appender);
        }
        this.appenderTracker.removeStaleComponents(this.now++);
        junit.framework.Assert.assertEquals((int)n, (int)this.appenderTracker.allKeys().size());
        junit.framework.Assert.assertNull((Object)this.appenderTracker.find(this.key + "-" + 0));
        junit.framework.Assert.assertFalse((boolean)((Appender)arrayList.get(0)).isStarted());
    }

    @Test
    public void trackerShouldHonorTimeoutParameter() {
        ArrayList<Appender> arrayList = new ArrayList<Appender>();
        int n = 2;
        this.appenderTracker.setTimeout((long)n);
        for (int i = 0; i <= n; ++i) {
            Appender appender = (Appender)this.appenderTracker.getOrCreate(this.key + "-" + i, this.now++);
            arrayList.add(appender);
        }
        long l = n + 1;
        junit.framework.Assert.assertEquals((long)l, (long)this.appenderTracker.allKeys().size());
        this.appenderTracker.removeStaleComponents(this.now++);
        junit.framework.Assert.assertEquals((long)(l - 1L), (long)this.appenderTracker.allKeys().size());
        junit.framework.Assert.assertNull((Object)this.appenderTracker.find(this.key + "-" + 0));
        junit.framework.Assert.assertFalse((boolean)((Appender)arrayList.get(0)).isStarted());
        for (int i = 1; i <= n; ++i) {
            Assert.assertNotNull((Object)this.appenderTracker.find(this.key + "-" + i));
            junit.framework.Assert.assertTrue((boolean)((Appender)arrayList.get(i)).isStarted());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListAppenderFactory
    implements AppenderFactory<Object> {
        ListAppenderFactory() {
        }

        public Appender<Object> buildAppender(Context context, String string) throws JoranException {
            ListAppender listAppender = new ListAppender();
            listAppender.setContext(context);
            listAppender.setName(string);
            listAppender.start();
            return listAppender;
        }
    }
}

