/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AppenderAttachableImplTest {
    private AppenderAttachableImpl<TestEvent> aai;

    @Before
    public void setUp() throws Exception {
        this.aai = new AppenderAttachableImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.aai = null;
    }

    @Test
    public void testAddAppender() throws Exception {
        TestEvent testEvent = new TestEvent();
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        nOPAppender = new NOPAppender();
        nOPAppender.setName("test");
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        int n = this.aai.appendLoopOnAppenders((Object)testEvent);
        Assert.assertTrue((String)"Incorrect number of appenders", (n == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testIteratorForAppenders() throws Exception {
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        NOPAppender nOPAppender2 = new NOPAppender();
        nOPAppender2.setName("test");
        nOPAppender2.start();
        this.aai.addAppender((Appender)nOPAppender2);
        Iterator iterator = this.aai.iteratorForAppenders();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            Appender appender = (Appender)iterator.next();
            Assert.assertTrue((String)"Bad Appender", (appender == nOPAppender || appender == nOPAppender2 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Incorrect number of appenders", (n == 2 ? 1 : 0) != 0);
    }

    @Test
    public void getGetAppender() throws Exception {
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.setName("test");
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        NOPAppender nOPAppender2 = new NOPAppender();
        nOPAppender2.setName("testOther");
        nOPAppender2.start();
        this.aai.addAppender((Appender)nOPAppender2);
        Appender appender = this.aai.getAppender("testOther");
        Assert.assertNotNull((String)"Could not find appender", (Object)appender);
        Assert.assertTrue((String)"Wrong appender", (appender == nOPAppender2 ? 1 : 0) != 0);
        appender = this.aai.getAppender("test");
        Assert.assertNotNull((String)"Could not find appender", (Object)appender);
        Assert.assertTrue((String)"Wrong appender", (appender == nOPAppender ? 1 : 0) != 0);
        appender = this.aai.getAppender("NotThere");
        Assert.assertNull((String)"Appender was returned", (Object)appender);
    }

    @Test
    public void testIsAttached() throws Exception {
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        NOPAppender nOPAppender2 = new NOPAppender();
        nOPAppender2.setName("test");
        nOPAppender2.start();
        this.aai.addAppender((Appender)nOPAppender2);
        Assert.assertTrue((String)"Appender is not attached", (boolean)this.aai.isAttached((Appender)nOPAppender));
        Assert.assertTrue((String)"Appender is not attached", (boolean)this.aai.isAttached((Appender)nOPAppender2));
    }

    @Test
    public void testDetachAndStopAllAppenders() throws Exception {
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        NOPAppender nOPAppender2 = new NOPAppender();
        nOPAppender2.setName("test");
        nOPAppender2.start();
        this.aai.addAppender((Appender)nOPAppender2);
        Assert.assertTrue((String)"Appender was not started", (boolean)nOPAppender2.isStarted());
        this.aai.detachAndStopAllAppenders();
        Assert.assertNull((String)"Appender was not removed", (Object)this.aai.getAppender("test"));
        Assert.assertFalse((String)"Appender was not stopped", (boolean)nOPAppender2.isStarted());
    }

    @Test
    public void testDetachAppender() throws Exception {
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        NOPAppender nOPAppender2 = new NOPAppender();
        nOPAppender2.setName("test");
        nOPAppender2.start();
        this.aai.addAppender((Appender)nOPAppender2);
        Assert.assertTrue((String)"Appender not detached", (boolean)this.aai.detachAppender((Appender)nOPAppender2));
        Assert.assertNull((String)"Appender was not removed", (Object)this.aai.getAppender("test"));
        Assert.assertFalse((String)"Appender detach error", (boolean)this.aai.detachAppender((Appender)nOPAppender2));
    }

    @Test
    public void testDetachAppenderByName() throws Exception {
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.setName("test1");
        nOPAppender.start();
        this.aai.addAppender((Appender)nOPAppender);
        NOPAppender nOPAppender2 = new NOPAppender();
        nOPAppender2.setName("test");
        nOPAppender2.start();
        this.aai.addAppender((Appender)nOPAppender2);
        Assert.assertTrue((boolean)this.aai.detachAppender("test"));
        Assert.assertTrue((boolean)this.aai.detachAppender("test1"));
        Assert.assertFalse((boolean)this.aai.detachAppender("test1"));
    }

    private static class TestEvent {
        private TestEvent() {
        }
    }
}

