/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.ComponentTracker;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.spi.CyclicBufferTrackerT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTrackerSimulator {
    CyclicBufferTracker<Object> realCBTracker = new CyclicBufferTracker();
    CyclicBufferTrackerT<Object> t_CBTracker = new CyclicBufferTrackerT();
    List<SimulationEvent> scenario = new ArrayList<SimulationEvent>();
    List<String> keySpace = new ArrayList<String>();
    Random randomKeyGen = new Random(100L);
    Random simulatorRandom = new Random(11234L);
    Parameters params;
    int getToEndOfLifeRatio = 10;

    CyclicBufferTrackerSimulator(Parameters parameters) {
        this.params = parameters;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < parameters.keySpaceLen; ++i) {
            String string = this.getRandomKeyStr();
            if (hashMap.containsKey(string)) {
                System.out.println("random key collision occurred");
                string = string + "" + i;
            }
            this.keySpace.add(string);
            hashMap.put(string, string);
        }
    }

    private String getRandomKeyStr() {
        int n = this.randomKeyGen.nextInt();
        return String.format("%X", n);
    }

    void buildScenario() {
        long l = 30000L;
        int n = this.keySpace.size();
        for (int i = 0; i < this.params.simulationLength; ++i) {
            int n2 = this.simulatorRandom.nextInt(n);
            String string = this.keySpace.get(n2);
            this.scenario.add(new SimulationEvent(EventType.INSERT, string, l += (long)this.simulatorRandom.nextInt(this.params.maxTimestampInc)));
            if (this.simulatorRandom.nextInt(this.getToEndOfLifeRatio) == 0) {
                this.scenario.add(new SimulationEvent(EventType.END_OF_LIFE, string, l));
            }
            this.scenario.add(new SimulationEvent(EventType.REMOVE_STALE, string, l));
        }
    }

    public void dump() {
        for (SimulationEvent simulationEvent : this.scenario) {
            System.out.println(simulationEvent);
        }
    }

    void play(SimulationEvent simulationEvent, ComponentTracker<CyclicBuffer<Object>> componentTracker) {
        String string = simulationEvent.key;
        long l = simulationEvent.timestamp;
        EventType eventType = simulationEvent.eventType;
        switch (eventType) {
            case INSERT: {
                componentTracker.getOrCreate(string, l);
                break;
            }
            case END_OF_LIFE: {
                componentTracker.endOfLife(string);
                break;
            }
            case REMOVE_STALE: {
                componentTracker.removeStaleComponents(l);
            }
        }
    }

    public void simulate() {
        for (SimulationEvent simulationEvent : this.scenario) {
            this.play(simulationEvent, (ComponentTracker<CyclicBuffer<Object>>)this.realCBTracker);
            this.play(simulationEvent, this.t_CBTracker);
        }
    }

    class SimulationEvent {
        public final String key;
        public final long timestamp;
        final EventType eventType;

        public SimulationEvent(EventType eventType, String string, long l) {
            this.eventType = eventType;
            this.key = string;
            this.timestamp = l;
        }

        public String toString() {
            return "SimulationEvent{eventType=" + (Object)((Object)this.eventType) + ", key='" + this.key + '\'' + ", timestamp=" + this.timestamp + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EventType {
        INSERT,
        END_OF_LIFE,
        REMOVE_STALE;

    }

    static class Parameters {
        public int keySpaceLen;
        public int maxTimestampInc;
        public int simulationLength;

        Parameters() {
        }
    }
}

