/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.ComponentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTrackerT<E>
implements ComponentTracker<CyclicBuffer<E>> {
    int bufferSize = 256;
    int maxComponents = 64;
    List<TEntry<E>> liveList = new LinkedList<TEntry<E>>();
    List<TEntry<E>> lingererList = new LinkedList<TEntry<E>>();
    long lastCheck = 0L;

    private TEntry<E> getEntry(List<TEntry<E>> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            TEntry<E> tEntry = list.get(i);
            if (!tEntry.key.equals(string)) continue;
            return tEntry;
        }
        return null;
    }

    private TEntry getFromEitherList(String string) {
        TEntry<E> tEntry = this.getEntry(this.liveList, string);
        if (tEntry != null) {
            return tEntry;
        }
        return this.getEntry(this.lingererList, string);
    }

    private List<String> keysAsOrderedList(List<TEntry<E>> list) {
        Collections.sort(list);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < list.size(); ++i) {
            TEntry<E> tEntry = list.get(i);
            linkedList.add(tEntry.key);
        }
        return linkedList;
    }

    List<String> liveKeysAsOrderedList() {
        return this.keysAsOrderedList(this.liveList);
    }

    List<String> lingererKeysAsOrderedList() {
        return this.keysAsOrderedList(this.lingererList);
    }

    public Set<String> allKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        for (TEntry<E> tEntry : this.liveList) {
            hashSet.add(tEntry.key);
        }
        for (TEntry<E> tEntry : this.lingererList) {
            hashSet.add(tEntry.key);
        }
        return hashSet;
    }

    public Collection<CyclicBuffer<E>> allComponents() {
        ArrayList arrayList = new ArrayList();
        for (TEntry<E> tEntry : this.liveList) {
            arrayList.add(tEntry.value);
        }
        for (TEntry<E> tEntry : this.lingererList) {
            arrayList.add(tEntry.value);
        }
        return arrayList;
    }

    public CyclicBuffer<E> find(String string) {
        TEntry tEntry = this.getFromEitherList(string);
        if (tEntry == null) {
            return null;
        }
        return tEntry.value;
    }

    public CyclicBuffer<E> getOrCreate(String string, long l) {
        TEntry tEntry = this.getFromEitherList(string);
        if (tEntry == null) {
            CyclicBuffer cyclicBuffer = new CyclicBuffer(this.bufferSize);
            tEntry = new TEntry(string, cyclicBuffer, l);
            this.liveList.add(tEntry);
            if (this.liveList.size() > this.maxComponents) {
                Collections.sort(this.liveList);
                this.liveList.remove(0);
            }
        } else {
            tEntry.timestamp = l;
            Collections.sort(this.liveList);
        }
        return tEntry.value;
    }

    public void endOfLife(String string) {
        TEntry<E> tEntry = null;
        boolean bl = false;
        for (int i = 0; i < this.liveList.size(); ++i) {
            tEntry = this.liveList.get(i);
            if (!tEntry.key.equals(string)) continue;
            this.liveList.remove(i);
            bl = true;
            break;
        }
        if (bl) {
            this.lingererList.add(tEntry);
        }
    }

    private boolean isEntryStale(TEntry<E> tEntry, long l) {
        return tEntry.timestamp + 1800000L < l;
    }

    private boolean isEntryDoneLingering(TEntry<E> tEntry, long l) {
        return tEntry.timestamp + 10000L < l;
    }

    public void removeStaleComponents(long l) {
        if (this.isTooSoonForRemovalIteration(l)) {
            return;
        }
        Collections.sort(this.liveList);
        Collections.sort(this.lingererList);
        this.removeComponentsInExcessFromMainList();
        this.removeStaleComponentsFromMainList(l);
        this.removeStaleComponentsFromLingerersList(l);
    }

    private void removeComponentsInExcessFromMainList() {
        while (this.liveList.size() > this.maxComponents) {
            this.liveList.remove(0);
        }
    }

    private void removeStaleComponentsFromMainList(long l) {
        while (this.liveList.size() != 0 && this.isEntryStale(this.liveList.get(0), l)) {
            this.liveList.remove(0);
        }
    }

    private void removeStaleComponentsFromLingerersList(long l) {
        while (this.lingererList.size() != 0 && this.isEntryDoneLingering(this.lingererList.get(0), l)) {
            this.lingererList.remove(0);
        }
    }

    private boolean isTooSoonForRemovalIteration(long l) {
        if (this.lastCheck + 1000L > l) {
            return true;
        }
        this.lastCheck = l;
        return false;
    }

    public int getComponentCount() {
        return this.liveList.size() + this.lingererList.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TEntry<X>
    implements Comparable<TEntry<?>> {
        String key;
        CyclicBuffer<E> value;
        long timestamp;

        TEntry(String string, CyclicBuffer<E> cyclicBuffer, long l) {
            this.key = string;
            this.value = cyclicBuffer;
            this.timestamp = l;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
            return n;
        }

        @Override
        public int compareTo(TEntry<?> tEntry) {
            if (!(tEntry instanceof TEntry)) {
                throw new IllegalArgumentException("arguments must be of type " + TEntry.class);
            }
            TEntry<?> tEntry2 = tEntry;
            if (this.timestamp > tEntry2.timestamp) {
                return 1;
            }
            if (this.timestamp == tEntry2.timestamp) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TEntry tEntry = (TEntry)object;
            if (this.key == null ? tEntry.key != null : !this.key.equals(tEntry.key)) {
                return false;
            }
            return !(this.value == null ? tEntry.value != null : !this.value.equals(tEntry.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

