/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import junit.framework.Assert;
import org.junit.Test;

public class CyclicBufferTrackerTest {
    CyclicBufferTracker<Object> tracker = new CyclicBufferTracker();
    String key = "a";

    @Test
    public void empty0() {
        long l = 3000L;
        this.tracker.removeStaleComponents(l);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
    }

    @Test
    public void empty1() {
        long l = 3000L;
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, l++));
        this.tracker.removeStaleComponents(l += 1801000L);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, l++));
    }

    @Test
    public void smoke() {
        long l = 3000L;
        CyclicBuffer cyclicBuffer = (CyclicBuffer)this.tracker.getOrCreate(this.key, l);
        Assert.assertEquals((Object)cyclicBuffer, (Object)this.tracker.getOrCreate(this.key, l++));
        this.tracker.removeStaleComponents(l += 1801000L);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
    }

    @Test
    public void destroy() {
        long l = 3000L;
        CyclicBuffer cyclicBuffer = (CyclicBuffer)this.tracker.getOrCreate(this.key, l);
        cyclicBuffer.add(new Object());
        Assert.assertEquals((int)1, (int)cyclicBuffer.length());
        this.tracker.endOfLife(this.key);
        this.tracker.removeStaleComponents(l += 10010L);
        Assert.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((int)0, (int)this.tracker.getComponentCount());
        Assert.assertEquals((int)0, (int)cyclicBuffer.length());
    }
}

