/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import java.util.Iterator;
import junit.framework.TestCase;

public class StatusBaseTest
extends TestCase {
    public void testAddStatus() {
        InfoStatus infoStatus = new InfoStatus("testing", (Object)this);
        infoStatus.add((Status)new ErrorStatus("error", (Object)this));
        Iterator iterator = infoStatus.iterator();
        StatusBaseTest.assertTrue((String)"No status was added", (boolean)iterator.hasNext());
        StatusBaseTest.assertTrue((String)"hasChilden method reported wrong result", (boolean)infoStatus.hasChildren());
        infoStatus = new InfoStatus("testing", (Object)this);
        try {
            infoStatus.add(null);
            StatusBaseTest.fail((String)"method should have thrown an Exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveStatus() {
        InfoStatus infoStatus = new InfoStatus("testing", (Object)this);
        ErrorStatus errorStatus = new ErrorStatus("error", (Object)this);
        infoStatus.add((Status)errorStatus);
        boolean bl = infoStatus.remove((Status)errorStatus);
        Iterator iterator = infoStatus.iterator();
        StatusBaseTest.assertTrue((String)"Remove failed", (boolean)bl);
        StatusBaseTest.assertFalse((String)"No status was removed", (boolean)iterator.hasNext());
        StatusBaseTest.assertFalse((String)"hasChilden method reported wrong result", (boolean)infoStatus.hasChildren());
        infoStatus = new InfoStatus("testing", (Object)this);
        errorStatus = new ErrorStatus("error", (Object)this);
        infoStatus.add((Status)errorStatus);
        bl = infoStatus.remove(null);
        StatusBaseTest.assertFalse((String)"Remove result was not false", (boolean)bl);
    }

    public void testEffectiveLevel() {
        ErrorStatus errorStatus = new ErrorStatus("error", (Object)this);
        WarnStatus warnStatus = new WarnStatus("warning", (Object)this);
        errorStatus.add((Status)warnStatus);
        StatusBaseTest.assertEquals((String)"effective level misevaluated", (int)errorStatus.getEffectiveLevel(), (int)2);
        errorStatus = new InfoStatus("info", (Object)this);
        warnStatus = new WarnStatus("warning", (Object)this);
        errorStatus.add((Status)warnStatus);
        StatusBaseTest.assertEquals((String)"effective level misevaluated", (int)errorStatus.getEffectiveLevel(), (int)1);
        errorStatus = new InfoStatus("info", (Object)this);
        warnStatus = new WarnStatus("warning", (Object)this);
        ErrorStatus errorStatus2 = new ErrorStatus("error", (Object)this);
        errorStatus.add((Status)warnStatus);
        warnStatus.add((Status)errorStatus2);
        StatusBaseTest.assertEquals((String)"effective level misevaluated", (int)errorStatus.getEffectiveLevel(), (int)2);
    }
}

