/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Tokenizer;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    @Test
    public void literal() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("abc");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.LITERAL, (Object)"abc");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void literalWithAccolade0() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("{}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.LITERAL, (Object)"{");
        node2.next = new Node(Node.Type.LITERAL, (Object)"}");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void literalWithAccolade1() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("%x{a}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.LITERAL, (Object)"%x");
        Node node3 = node2.next = new Node(Node.Type.LITERAL, (Object)"{");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"a");
        node3.next = new Node(Node.Type.LITERAL, (Object)"}");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void literalWithTwoAccolades() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("%x{y} %a{b} c");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.LITERAL, (Object)"%x");
        Node node3 = node2.next = new Node(Node.Type.LITERAL, (Object)"{");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"y");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"}");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)" %a");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"{");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"b");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"}");
        node3.next = new Node(Node.Type.LITERAL, (Object)" c");
        node.dump();
        System.out.println("");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void variable() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("${abc}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"abc"));
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void literalVariableLiteral() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("a${b}c");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.LITERAL, (Object)"a");
        node2.next = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"b"));
        node2.next.next = new Node(Node.Type.LITERAL, (Object)"c");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void withColon() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("a:${b}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.LITERAL, (Object)"a");
        Node node3 = node2.next = new Node(Node.Type.LITERAL, (Object)":");
        node3.next = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"b"));
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void nested() throws ScanException {
        Node node;
        Tokenizer tokenizer = new Tokenizer("a${b${c}}d");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node2 = parser.parse();
        Node node3 = new Node(Node.Type.LITERAL, (Object)"a");
        Node node4 = new Node(Node.Type.LITERAL, (Object)"b");
        Node node5 = new Node(Node.Type.LITERAL, (Object)"c");
        Node node6 = new Node(Node.Type.VARIABLE, (Object)node4);
        node4.next = node = new Node(Node.Type.VARIABLE, (Object)node5);
        node3.next = node6;
        node3.next.next = new Node(Node.Type.LITERAL, (Object)"d");
        Assert.assertEquals((Object)node3, (Object)node2);
    }

    @Test
    public void withDefault() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("${b:-c}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        Node node2 = new Node(Node.Type.VARIABLE, (Object)new Node(Node.Type.LITERAL, (Object)"b"));
        node2.defaultPart = new Node(Node.Type.LITERAL, (Object)"c");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void defaultSeparatorOutsideOfAVariable() throws ScanException {
        Tokenizer tokenizer = new Tokenizer("{a:-b}");
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        this.dump(node);
        Node node2 = new Node(Node.Type.LITERAL, (Object)"{");
        Node node3 = node2.next = new Node(Node.Type.LITERAL, (Object)"a");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)":-");
        node3 = node3.next = new Node(Node.Type.LITERAL, (Object)"b");
        node3.next = new Node(Node.Type.LITERAL, (Object)"}");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    private void dump(Node node) {
        while (node != null) {
            System.out.println(node.toString());
            node = node.next;
        }
    }
}

