/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Token;
import ch.qos.logback.core.subst.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TokenizerTest {
    List<Token> witnessList = new ArrayList<Token>();

    @Test
    public void literalOnly() throws ScanException {
        String string = "abc";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, string));
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void literalWithAccolades() throws ScanException {
        String string = "%logger";
        String string2 = "24";
        String string3 = " - %m";
        String string4 = string + "{" + string2 + "}" + string3;
        Tokenizer tokenizer = new Tokenizer(string4);
        List list = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, string));
        this.witnessList.add(Token.CURLY_LEFT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, string2));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, string3));
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void simleVariable() throws ScanException {
        String string = "${abc}";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "abc"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void mix() throws ScanException {
        String string = "a${b}c";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "c"));
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void nested() throws ScanException {
        String string = "a${b${c}}";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "c"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void basicDefaultSeparator() throws ScanException {
        String string = "${a:-b}";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.DEFAULT_SEP_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void colon() throws ScanException {
        String string = "a:b";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(new Token(Token.Type.LITERAL, ":b"));
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void colonFollowedByDollar() throws ScanException {
        String string = "a:${b}";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(new Token(Token.Type.LITERAL, ":"));
        this.witnessList.add(Token.START_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)list);
    }

    @Test
    public void defaultSeparatorOutsideVariable() throws ScanException {
        String string = "{a:-b}";
        Tokenizer tokenizer = new Tokenizer(string);
        List list = tokenizer.tokenize();
        this.witnessList.add(Token.CURLY_LEFT_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "a"));
        this.witnessList.add(Token.DEFAULT_SEP_TOKEN);
        this.witnessList.add(new Token(Token.Type.LITERAL, "b"));
        this.witnessList.add(Token.CURLY_RIGHT_TOKEN);
        Assert.assertEquals(this.witnessList, (Object)list);
    }
}

