/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class Compare {
    static final int B1_NULL = -1;
    static final int B2_NULL = -2;

    public static boolean compare(String string, String string2) throws FileNotFoundException, IOException {
        if (string.endsWith(".gz")) {
            return Compare.gzFileCompare(string, string2);
        }
        if (string.endsWith(".zip")) {
            return Compare.zipFileCompare(string, string2);
        }
        return Compare.regularFileCompare(string, string2);
    }

    static BufferedReader gzFileToBufferedReader(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        return new BufferedReader(new InputStreamReader(gZIPInputStream));
    }

    static BufferedReader zipFileToBufferedReader(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        zipInputStream.getNextEntry();
        return new BufferedReader(new InputStreamReader(zipInputStream));
    }

    public static boolean gzFileCompare(String string, String string2) throws IOException {
        BufferedReader bufferedReader = Compare.gzFileToBufferedReader(string);
        BufferedReader bufferedReader2 = Compare.gzFileToBufferedReader(string2);
        return Compare.bufferCompare(bufferedReader, bufferedReader2, string, string2);
    }

    public static boolean zipFileCompare(String string, String string2) throws IOException {
        BufferedReader bufferedReader = Compare.zipFileToBufferedReader(string);
        BufferedReader bufferedReader2 = Compare.zipFileToBufferedReader(string2);
        return Compare.bufferCompare(bufferedReader, bufferedReader2, string, string2);
    }

    public static boolean regularFileCompare(String string, String string2) throws FileNotFoundException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string2));
        return Compare.bufferCompare(bufferedReader, bufferedReader2, string, string2);
    }

    public static boolean bufferCompare(BufferedReader bufferedReader, BufferedReader bufferedReader2, String string, String string2) throws FileNotFoundException, IOException {
        String string3;
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            ++n;
            String string4 = bufferedReader2.readLine();
            if (string3.equals(string4)) continue;
            System.out.println("Files [" + string + "] and [" + string2 + "] differ on line " + n);
            System.out.println("One reads:  [" + string3 + "].");
            System.out.println("Other reads:[" + string4 + "].");
            Compare.outputFile(string);
            Compare.outputFile(string2);
            return false;
        }
        if (bufferedReader2.read() != -1) {
            System.out.println("File [" + string2 + "] longer than file [" + string + "].");
            Compare.outputFile(string);
            Compare.outputFile(string2);
            return false;
        }
        return true;
    }

    private static void outputFile(String string) throws FileNotFoundException, IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        System.out.println("--------------------------------");
        System.out.println("Contents of " + string + ":");
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.print(++n);
            if (n < 10) {
                System.out.print("   : ");
            } else if (n < 100) {
                System.out.print("  : ");
            } else if (n < 1000) {
                System.out.print(" : ");
            } else {
                System.out.print(": ");
            }
            System.out.println(string2);
        }
    }

    public static boolean gzCompare(String string, String string2) throws FileNotFoundException, IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string))));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string2))));
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            ++n;
            String string4 = bufferedReader2.readLine();
            if (string3.equals(string4)) continue;
            System.out.println("Files [" + string + "] and [" + string2 + "] differ on line " + n);
            System.out.println("One reads:  [" + string3 + "].");
            System.out.println("Other reads:[" + string4 + "].");
            Compare.outputFile(string);
            Compare.outputFile(string2);
            return false;
        }
        if (bufferedReader2.read() != -1) {
            System.out.println("File [" + string2 + "] longer than file [" + string + "].");
            Compare.outputFile(string);
            Compare.outputFile(string2);
            return false;
        }
        return true;
    }
}

