/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatePatternToRegexTest {
    static Calendar CAL_2009_08_3_NIGHT = Calendar.getInstance();
    static Calendar CAL_2009_08_3_MORNING = Calendar.getInstance();

    @BeforeClass
    public static void setUpCalendars() {
        CAL_2009_08_3_NIGHT.set(2009, 8, 3, 21, 57, 16);
        CAL_2009_08_3_NIGHT.set(14, 333);
        CAL_2009_08_3_MORNING.set(2009, 8, 3, 10, 24, 37);
        CAL_2009_08_3_MORNING.set(14, 333);
    }

    @Test
    public void ISO8601() {
        this.doTest("yyyy-MM-dd HH:mm:ss,SSS", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void withQuotes() {
        this.doTest("yyyy-MM-dd'T'HH:mm:ss,SSS", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void month() {
        this.doTest("yyyy-MMM-dd", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMMM-dd", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void dot() {
        this.doTest("yyyy.MMM.dd", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void timeZone() {
        this.doTest("yyyy-MMM-dd HH:mm:ss z", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-dd HH:mm:ss Z", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void dayInWeek() {
        this.doTest("yyyy-MMM-E", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-EE", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MMM-EEE", CAL_2009_08_3_NIGHT);
    }

    @Test
    public void amPm() {
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_NIGHT);
        this.doTest("yyyy-MM-dd a", CAL_2009_08_3_MORNING);
    }

    void doTest(String string, Calendar calendar, boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        DateTokenConverter dateTokenConverter = this.makeDTC(string);
        this.verify(simpleDateFormat, calendar, dateTokenConverter, bl);
    }

    void doTest(String string, Calendar calendar) {
        this.doTest(string, calendar, false);
    }

    void verify(SimpleDateFormat simpleDateFormat, Calendar calendar, DateTokenConverter dateTokenConverter, boolean bl) {
        String string = simpleDateFormat.format(calendar.getTime());
        if (bl) {
            string = string.replace('\\', '/');
        }
        String string2 = dateTokenConverter.toRegex();
        Assert.assertTrue((String)("[" + string + "] does not match regex [" + string2 + "]"), (boolean)string.matches(string2));
    }

    private DateTokenConverter makeDTC(String string) {
        DateTokenConverter dateTokenConverter = new DateTokenConverter();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        dateTokenConverter.setOptionList(arrayList);
        dateTokenConverter.start();
        return dateTokenConverter;
    }
}

