/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.util.Compare;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileUtilTest {
    Context context = new ContextBase();
    FileUtil fileUtil = new FileUtil(this.context);
    List<File> cleanupList = new ArrayList<File>();
    int diff = new Random().nextInt(10000);

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        for (File file : this.cleanupList) {
            file.delete();
        }
    }

    @Test
    public void checkParentCreationInquiryAndSubsequentCreation() {
        File file = new File("target/test-output//fu" + this.diff + "/testing.txt");
        this.cleanupList.add(file);
        this.cleanupList.add(file.getParentFile());
        Assert.assertTrue((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
        Assert.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
        Assert.assertFalse((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
    }

    @Test
    public void checkDeeperParentCreationInquiryAndSubsequentCreation() {
        File file = new File("target/test-output//fu" + this.diff + "/bla/testing.txt");
        this.cleanupList.add(file);
        this.cleanupList.add(file.getParentFile());
        this.cleanupList.add(file.getParentFile().getParentFile());
        Assert.assertTrue((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
        Assert.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
        Assert.assertFalse((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
    }

    @Test
    public void basicCopyingWorks() throws IOException {
        String string = "target/test-output//fu" + this.diff;
        File file = new File(string);
        file.mkdir();
        String string2 = "src/test/input/compress1.copy";
        String string3 = "target/test-output//fu" + this.diff + "/copyingWorks.txt";
        this.fileUtil.copy(string2, string3);
        Compare.compare(string2, string3);
    }
}

