/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.LocationUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class LocationUtilTest {
    private static final String TEST_CLASSPATH_RESOURCE = "util/testResource.txt";
    private static final String TEST_PATTERN = "TEST RESOURCE";

    @Test
    public void testImplicitClasspathUrl() throws Exception {
        URL uRL = LocationUtil.urlForResource((String)TEST_CLASSPATH_RESOURCE);
        this.validateResource(uRL);
    }

    @Test
    public void testExplicitClasspathUrl() throws Exception {
        URL uRL = LocationUtil.urlForResource((String)"classpath:util/testResource.txt");
        this.validateResource(uRL);
    }

    @Test
    public void testExplicitClasspathUrlWithLeadingSlash() throws Exception {
        URL uRL = LocationUtil.urlForResource((String)"classpath:/util/testResource.txt");
        this.validateResource(uRL);
    }

    @Test(expected=MalformedURLException.class)
    public void testExplicitClasspathUrlEmptyPath() throws Exception {
        LocationUtil.urlForResource((String)"classpath:");
    }

    @Test(expected=MalformedURLException.class)
    public void testExplicitClasspathUrlWithRootPath() throws Exception {
        LocationUtil.urlForResource((String)"classpath:/");
    }

    @Test
    public void testFileUrl() throws Exception {
        File file = File.createTempFile("testResource", ".txt");
        file.deleteOnExit();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println(TEST_PATTERN);
        printWriter.close();
        URL uRL = file.toURI().toURL();
        this.validateResource(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateResource(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            Assert.assertEquals((Object)TEST_PATTERN, (Object)string);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }
}

