/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OptionHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    String text = "Testing ${v1} variable substitution ${v2}";
    String expected = "Testing if variable substitution works";
    Context context = new ContextBase();
    Map<String, String> secondaryMap;

    @Before
    public void setUp() throws Exception {
        this.secondaryMap = new HashMap<String, String>();
    }

    @Test
    public void testLiteral() {
        String string = "hello world";
        String string2 = OptionHelper.substVars((String)string, (PropertyContainer)this.context);
        Assert.assertEquals((String)string, (String)string2);
    }

    @Test
    public void testUndefinedValues() {
        String string = "${axyz}";
        String string2 = OptionHelper.substVars((String)string, (PropertyContainer)this.context);
        Assert.assertEquals((String)"axyz_IS_UNDEFINED", (String)string2);
    }

    @Test
    public void testSubstVarsVariableNotClosed() {
        String string = "testing if ${v1 works";
        try {
            String string2 = OptionHelper.substVars((String)string, (PropertyContainer)this.context);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSubstVarsContextOnly() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "works");
        String string = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((String)this.expected, (String)string);
    }

    @Test
    public void testSubstVarsSystemProperties() {
        System.setProperty("v1", "if");
        System.setProperty("v2", "works");
        String string = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((String)this.expected, (String)string);
        System.clearProperty("v1");
        System.clearProperty("v2");
    }

    @Test
    public void testSubstVarsWithDefault() {
        this.context.putProperty("v1", "if");
        String string = "Testing ${v1} variable substitution ${v2:-toto}";
        String string2 = "Testing if variable substitution toto";
        String string3 = OptionHelper.substVars((String)string, (PropertyContainer)this.context);
        Assert.assertEquals((String)string2, (String)string3);
    }

    @Test
    public void testSubstVarsRecursive() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "works");
        String string = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((String)this.expected, (String)string);
    }

    @Test
    public void testSubstVarsTwoLevelsDeep() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "${v4}");
        this.context.putProperty("v4", "works");
        String string = OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
        Assert.assertEquals((String)this.expected, (String)string);
    }

    @Test
    public void testSubstVarsTwoLevelsWithDefault() {
        this.context.putProperty("APP_NAME", "LOGBACK");
        this.context.putProperty("ARCHIVE_SUFFIX", "archive.log");
        this.context.putProperty("LOG_HOME", "${logfilepath.default:-logs}");
        this.context.putProperty("ARCHIVE_PATH", "${LOG_HOME}/archive/${APP_NAME}");
        String string = OptionHelper.substVars((String)"${ARCHIVE_PATH}_trace_${ARCHIVE_SUFFIX}", (PropertyContainer)this.context);
        Assert.assertEquals((String)"logs/archive/LOGBACK_trace_archive.log", (String)string);
    }

    @Test(timeout=1000L)
    public void stubstVarsShouldNotGoIntoInfiniteLoop() {
        this.context.putProperty("v1", "if");
        this.context.putProperty("v2", "${v3}");
        this.context.putProperty("v3", "${v4}");
        this.context.putProperty("v4", "${v2}c");
        this.expectedException.expect(Exception.class);
        OptionHelper.substVars((String)this.text, (PropertyContainer)this.context);
    }

    @Test
    public void nonCircularGraphShouldWork() {
        this.context.putProperty("A", "${B} and ${C}");
        this.context.putProperty("B", "${B1}");
        this.context.putProperty("B1", "B1-value");
        this.context.putProperty("C", "${C1} and ${B}");
        this.context.putProperty("C1", "C1-value");
        String string = OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
        Assert.assertEquals((String)"B1-value and C1-value and B1-value", (String)string);
    }

    @Test(timeout=1000L)
    public void detectCircularReferences0() {
        this.context.putProperty("A", "${A}");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${A} --> ${A}]");
        OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
    }

    @Test(timeout=1000L)
    public void detectCircularReferences1() {
        this.context.putProperty("A", "${A}a");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${A} --> ${A}]");
        OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
    }

    @Test(timeout=1000L)
    public void detectCircularReferences2() {
        this.context.putProperty("A", "${B}");
        this.context.putProperty("B", "${C}");
        this.context.putProperty("C", "${A}");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${A} --> ${B} --> ${C} --> ${A}]");
        OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
    }

    @Test
    public void detectCircularReferencesInDefault() {
        this.context.putProperty("A", "${B:-${A}}");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${A} --> ${B} --> ${A}]");
        OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
    }

    @Test(timeout=1000L)
    public void detectCircularReferences3() {
        this.context.putProperty("A", "${B}");
        this.context.putProperty("B", "${C}");
        this.context.putProperty("C", "${A}");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${B} --> ${C} --> ${A} --> ${B}]");
        OptionHelper.substVars((String)"${B} ", (PropertyContainer)this.context);
    }

    @Test(timeout=1000L)
    public void detectCircularReferences4() {
        this.context.putProperty("A", "${B}");
        this.context.putProperty("B", "${C}");
        this.context.putProperty("C", "${A}");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${C} --> ${A} --> ${B} --> ${C}]");
        OptionHelper.substVars((String)"${C} and ${A}", (PropertyContainer)this.context);
    }

    @Test
    public void detectCircularReferences5() {
        this.context.putProperty("A", "${B} and ${C}");
        this.context.putProperty("B", "${B1}");
        this.context.putProperty("B1", "B1-value");
        this.context.putProperty("C", "${C1}");
        this.context.putProperty("C1", "here's the loop: ${A}");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Circular variable reference detected while parsing input [${A} --> ${C} --> ${C1} --> ${A}]");
        String string = OptionHelper.substVars((String)"${A}", (PropertyContainer)this.context);
        System.err.println(string);
    }

    @Test
    public void defaultValueReferencingAVariable() {
        this.context.putProperty("v1", "k1");
        String string = OptionHelper.substVars((String)"${undef:-${v1}}", (PropertyContainer)this.context);
        Assert.assertEquals((String)"k1", (String)string);
    }

    @Test
    public void jackrabbit_standalone() {
        String string = OptionHelper.substVars((String)"${jackrabbit.log:-${repo:-jackrabbit}/log/jackrabbit.log}", (PropertyContainer)this.context);
        Assert.assertEquals((String)"jackrabbit/log/jackrabbit.log", (String)string);
    }
}

