/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class StatusPrinterTest {
    ByteArrayOutputStream outputStream;
    PrintStream ps;

    @Before
    public void setUp() throws Exception {
        this.outputStream = new ByteArrayOutputStream();
        this.ps = new PrintStream(this.outputStream);
        StatusPrinter.setPrintStream((PrintStream)this.ps);
    }

    @After
    public void tearDown() throws Exception {
        StatusPrinter.setPrintStream((PrintStream)System.out);
        this.ps = null;
        this.outputStream = null;
    }

    @Test
    public void testBasic() {
        ContextBase contextBase = new ContextBase();
        contextBase.getStatusManager().add((Status)new InfoStatus("test", (Object)this));
        StatusPrinter.print((Context)contextBase);
        String string = this.outputStream.toString();
        Assert.assertTrue((boolean)string.contains("|-INFO in " + this.getClass().getName()));
    }

    @Test
    public void testNested() {
        ErrorStatus errorStatus = new ErrorStatus("test0", (Object)this);
        InfoStatus infoStatus = new InfoStatus("test1", (Object)this);
        InfoStatus infoStatus2 = new InfoStatus("test11", (Object)this);
        InfoStatus infoStatus3 = new InfoStatus("test12", (Object)this);
        infoStatus.add((Status)infoStatus2);
        infoStatus.add((Status)infoStatus3);
        InfoStatus infoStatus4 = new InfoStatus("test2", (Object)this);
        InfoStatus infoStatus5 = new InfoStatus("test21", (Object)this);
        WarnStatus warnStatus = new WarnStatus("test211", (Object)this);
        InfoStatus infoStatus6 = new InfoStatus("test22", (Object)this);
        infoStatus4.add((Status)infoStatus5);
        infoStatus4.add((Status)infoStatus6);
        infoStatus5.add((Status)warnStatus);
        ContextBase contextBase = new ContextBase();
        contextBase.getStatusManager().add((Status)errorStatus);
        contextBase.getStatusManager().add((Status)infoStatus);
        contextBase.getStatusManager().add((Status)infoStatus4);
        StatusPrinter.print((Context)contextBase);
        String string = this.outputStream.toString();
        Assert.assertTrue((boolean)string.contains("+ INFO in " + this.getClass().getName()));
        Assert.assertTrue((boolean)string.contains("+ WARN in " + this.getClass().getName()));
        Assert.assertTrue((boolean)string.contains("    |-WARN in " + this.getClass().getName()));
    }

    @Test
    public void testWithException() {
        ErrorStatus errorStatus = new ErrorStatus("test0", (Object)this);
        InfoStatus infoStatus = new InfoStatus("test1", (Object)this, (Throwable)new Exception("testEx"));
        InfoStatus infoStatus2 = new InfoStatus("test11", (Object)this);
        InfoStatus infoStatus3 = new InfoStatus("test12", (Object)this);
        infoStatus.add((Status)infoStatus2);
        infoStatus.add((Status)infoStatus3);
        InfoStatus infoStatus4 = new InfoStatus("test2", (Object)this);
        InfoStatus infoStatus5 = new InfoStatus("test21", (Object)this);
        WarnStatus warnStatus = new WarnStatus("test211", (Object)this);
        InfoStatus infoStatus6 = new InfoStatus("test22", (Object)this);
        infoStatus4.add((Status)infoStatus5);
        infoStatus4.add((Status)infoStatus6);
        infoStatus5.add((Status)warnStatus);
        ContextBase contextBase = new ContextBase();
        contextBase.getStatusManager().add((Status)errorStatus);
        contextBase.getStatusManager().add((Status)infoStatus);
        contextBase.getStatusManager().add((Status)infoStatus4);
        StatusPrinter.print((Context)contextBase);
        String string = this.outputStream.toString();
        Assert.assertTrue((boolean)string.contains("|-ERROR in " + this.getClass().getName()));
        Assert.assertTrue((boolean)string.contains("+ INFO in " + this.getClass().getName()));
        Assert.assertTrue((boolean)string.contains("ch.qos.logback.core.util.StatusPrinterTest.testWithException"));
    }
}

