/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.StringCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCollectionUtilTest {
    @Test
    public void testRetainMatchingWithNoPatterns() throws Exception {
        List<String> list = this.stringToList("A");
        StringCollectionUtil.retainMatching(list, (String[])new String[0]);
        Assert.assertTrue((boolean)list.contains("A"));
    }

    @Test
    public void testRetainMatchingWithMatchingPattern() throws Exception {
        List<String> list = this.stringToList("A");
        StringCollectionUtil.retainMatching(list, (String[])new String[]{"A"});
        Assert.assertTrue((boolean)list.contains("A"));
    }

    @Test
    public void testRetainMatchingWithNoMatchingPattern() throws Exception {
        List<String> list = this.stringToList("A");
        StringCollectionUtil.retainMatching(list, (String[])new String[]{"B"});
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testRemoveMatchingWithNoPatterns() throws Exception {
        List<String> list = this.stringToList("A");
        StringCollectionUtil.removeMatching(list, (String[])new String[0]);
        Assert.assertTrue((boolean)list.contains("A"));
    }

    @Test
    public void testRemoveMatchingWithMatchingPattern() throws Exception {
        List<String> list = this.stringToList("A");
        StringCollectionUtil.removeMatching(list, (String[])new String[]{"A"});
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testRemoveMatchingWithNoMatchingPattern() throws Exception {
        List<String> list = this.stringToList("A");
        StringCollectionUtil.removeMatching(list, (String[])new String[]{"B"});
        Assert.assertTrue((boolean)list.contains("A"));
    }

    private List<String> stringToList(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }
}

