// Automatically generated - do not modify!

package cesium

/**
 * Describes a compressed texture and contains a compressed texture buffer.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html">Online Documentation</a>
 *
 * @constructor
 * @param [internalFormat] The pixel format of the compressed texture.
 * @param [width] The width of the texture.
 * @param [height] The height of the texture.
 * @param [buffer] The compressed texture buffer.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html">Online Documentation</a>
 */
@JsName("\$cesium__CompressedTextureBuffer")
external class CompressedTextureBuffer(
    internalFormat: PixelFormat,
    width: Double,
    height: Double,
    buffer: org.khronos.webgl.Uint8Array,
) {
    /**
     * The format of the compressed texture.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html#internalFormat">Online Documentation</a>
     */
    val internalFormat: PixelFormat

    /**
     * The width of the texture.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html#width">Online Documentation</a>
     */
    val width: Double

    /**
     * The height of the texture.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html#height">Online Documentation</a>
     */
    val height: Double

    /**
     * The compressed texture buffer.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html#bufferView">Online Documentation</a>
     */
    val bufferView: org.khronos.webgl.Uint8Array

    /**
     * Creates a shallow clone of this compressed texture buffer.
     * @return A shallow clone of the compressed texture buffer.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html#clone">Online Documentation</a>
     */
    fun clone(): CompressedTextureBuffer

    companion object {
        /**
         * Creates a shallow clone of a compressed texture buffer.
         * @param [object] The compressed texture buffer to be cloned.
         * @return A shallow clone of the compressed texture buffer.
         * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CompressedTextureBuffer.html#.clone">Online Documentation</a>
         */
        fun clone(obj: CompressedTextureBuffer): CompressedTextureBuffer
    }
}
