// Automatically generated - do not modify!

package cesium

/**
 * The culling volume defined by planes.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CullingVolume.html">Online Documentation</a>
 *
 * @constructor
 * @param [planes] An array of clipping planes.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CullingVolume.html">Online Documentation</a>
 */
@JsName("\$cesium__CullingVolume")
external class CullingVolume(planes: Array<out Cartesian4>? = definedExternally) {
    /**
     * Each plane is represented by a Cartesian4 object, where the x, y, and z components
     * define the unit vector normal to the plane, and the w component is the distance of the
     * plane from the origin.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CullingVolume.html#planes">Online Documentation</a>
     */
    var planes: Array<out Cartesian4>

    /**
     * Determines whether a bounding volume intersects the culling volume.
     * @param [boundingVolume] The bounding volume whose intersection with the culling volume is to be tested.
     * @return Intersect.OUTSIDE, Intersect.INTERSECTING, or Intersect.INSIDE.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CullingVolume.html#computeVisibility">Online Documentation</a>
     */
    fun computeVisibility(boundingVolume: Any): Intersect

    companion object {
        /**
         * Constructs a culling volume from a bounding sphere. Creates six planes that create a box containing the sphere.
         * The planes are aligned to the x, y, and z axes in world coordinates.
         * @param [boundingSphere] The bounding sphere used to create the culling volume.
         * @param [result] The object onto which to store the result.
         * @return The culling volume created from the bounding sphere.
         * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/CullingVolume.html#.fromBoundingSphere">Online Documentation</a>
         */
        fun fromBoundingSphere(
            boundingSphere: BoundingSphere,
            result: CullingVolume? = definedExternally,
        ): CullingVolume
    }
}
