// Automatically generated - do not modify!

package cesium

/**
 * A utility object for tracking an entity with the camera.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html">Online Documentation</a>
 *
 * @constructor
 * @param [entity] The entity to track with the camera.
 * @param [scene] The scene to use.
 * @param [ellipsoid] The ellipsoid to use for orienting the camera.
 *   Default value - [Ellipsoid.WGS84]
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html">Online Documentation</a>
 */
@JsName("\$cesium__EntityView")
external class EntityView(
    entity: Entity,
    scene: Scene,
    ellipsoid: Ellipsoid? = definedExternally,
) {
    /**
     * The entity to track with the camera.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html#entity">Online Documentation</a>
     */
    var entity: Entity

    /**
     * The scene in which to track the object.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html#scene">Online Documentation</a>
     */
    var scene: Scene

    /**
     * The ellipsoid to use for orienting the camera.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html#ellipsoid">Online Documentation</a>
     */
    var ellipsoid: Ellipsoid

    /**
     * The bounding sphere of the object.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html#boundingSphere">Online Documentation</a>
     */
    var boundingSphere: BoundingSphere

    /**
     * Should be called each animation frame to update the camera
     * to the latest settings.
     * @param [time] The current animation time.
     * @param [boundingSphere] bounding sphere of the object.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html#update">Online Documentation</a>
     */
    fun update(
        time: JulianDate,
        boundingSphere: BoundingSphere? = definedExternally,
    )

    companion object {
        /**
         * Gets or sets a camera offset that will be used to
         * initialize subsequent EntityViews.
         * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/EntityView.html#.defaultOffset3D">Online Documentation</a>
         */
        var defaultOffset3D: Cartesian3
    }
}
