// Automatically generated - do not modify!

package cesium

/**
 * Represents a Gregorian date in a more precise format than the JavaScript Date object.
 * In addition to submillisecond precision, this object can also represent leap seconds.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html">Online Documentation</a>
 *
 * @constructor
 * @param [year] The year as a whole number.
 * @param [month] The month as a whole number with range [1, 12].
 * @param [day] The day of the month as a whole number starting at 1.
 * @param [hour] The hour as a whole number with range [0, 23].
 * @param [minute] The minute of the hour as a whole number with range [0, 59].
 * @param [second] The second of the minute as a whole number with range [0, 60], with 60 representing a leap second.
 * @param [millisecond] The millisecond of the second as a floating point number with range [0.0, 1000.0).
 * @param [isLeapSecond] Whether this time is during a leap second.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html">Online Documentation</a>
 */
@JsName("\$cesium__GregorianDate")
external class GregorianDate(
    year: Int? = definedExternally,
    month: Int? = definedExternally,
    day: Int? = definedExternally,
    hour: Int? = definedExternally,
    minute: Int? = definedExternally,
    second: Int? = definedExternally,
    millisecond: Int? = definedExternally,
    isLeapSecond: Boolean? = definedExternally,
) {
    /**
     * Gets or sets the year as a whole number.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#year">Online Documentation</a>
     */
    var year: Int

    /**
     * Gets or sets the month as a whole number with range [1, 12].
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#month">Online Documentation</a>
     */
    var month: Int

    /**
     * Gets or sets the day of the month as a whole number starting at 1.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#day">Online Documentation</a>
     */
    var day: Int

    /**
     * Gets or sets the hour as a whole number with range [0, 23].
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#hour">Online Documentation</a>
     */
    var hour: Int

    /**
     * Gets or sets the minute of the hour as a whole number with range [0, 59].
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#minute">Online Documentation</a>
     */
    var minute: Int

    /**
     * Gets or sets the second of the minute as a whole number with range [0, 60], with 60 representing a leap second.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#second">Online Documentation</a>
     */
    var second: Int

    /**
     * Gets or sets the millisecond of the second as a floating point number with range [0.0, 1000.0).
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#millisecond">Online Documentation</a>
     */
    var millisecond: Int

    /**
     * Gets or sets whether this time is during a leap second.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/GregorianDate.html#isLeapSecond">Online Documentation</a>
     */
    var isLeapSecond: Boolean
}
