// Automatically generated - do not modify!

package cesium

/**
 * Describes a single leap second, which is constructed from a [JulianDate] and a
 * numerical offset representing the number of seconds TAI is ahead of the UTC time standard.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/LeapSecond.html">Online Documentation</a>
 *
 * @constructor
 * @param [date] A Julian date representing the time of the leap second.
 * @param [offset] The cumulative number of seconds that TAI is ahead of UTC at the provided date.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/LeapSecond.html">Online Documentation</a>
 */
@JsName("\$cesium__LeapSecond")
external class LeapSecond(
    date: JulianDate? = definedExternally,
    offset: Double? = definedExternally,
) {
    /**
     * Gets or sets the date at which this leap second occurs.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/LeapSecond.html#julianDate">Online Documentation</a>
     */
    var julianDate: JulianDate

    /**
     * Gets or sets the cumulative number of seconds between the UTC and TAI time standards at the time
     * of this leap second.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/LeapSecond.html#offset">Online Documentation</a>
     */
    var offset: Double
}
