// Automatically generated - do not modify!

package cesium

/**
 * An event that is raised when a request encounters an error.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/RequestErrorEvent.html">Online Documentation</a>
 *
 * @constructor
 * @param [statusCode] The HTTP error status code, such as 404.
 * @param [response] The response included along with the error.
 * @param [responseHeaders] The response headers, represented either as an object literal or as a
 *   string in the format returned by XMLHttpRequest's getAllResponseHeaders() function.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/RequestErrorEvent.html">Online Documentation</a>
 */
@JsName("\$cesium__RequestErrorEvent")
external class RequestErrorEvent(
    statusCode: Int? = definedExternally,
    response: Any? = definedExternally,
    responseHeaders: dynamic = definedExternally,
) {
    /**
     * The HTTP error status code, such as 404.  If the error does not have a particular
     * HTTP code, this property will be undefined.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/RequestErrorEvent.html#statusCode">Online Documentation</a>
     */
    var statusCode: Int

    /**
     * The response included along with the error.  If the error does not include a response,
     * this property will be undefined.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/RequestErrorEvent.html#response">Online Documentation</a>
     */
    var response: Any

    /**
     * The headers included in the response, represented as an object literal of key/value pairs.
     * If the error does not include any headers, this property will be undefined.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/RequestErrorEvent.html#responseHeaders">Online Documentation</a>
     */
    var responseHeaders: Any
}
