// Automatically generated - do not modify!

package cesium

/**
 * A feature of a [Cesium3DTileset].
 *
 * Provides access to a feature's properties stored in the tile's batch table, as well
 * as the ability to show/hide a feature and change its highlight color via
 * [Cesium3DTileFeature.show] and [Cesium3DTileFeature.color], respectively.
 *
 * Modifications to a `Cesium3DTileFeature` object have the lifetime of the tile's
 * content.  If the tile's content is unloaded, e.g., due to it going out of view and needing
 * to free space in the cache for visible tiles, listen to the [Cesium3DTileset.tileUnload] event to save any
 * modifications. Also listen to the [Cesium3DTileset.tileVisible] event to reapply any modifications.
 *
 * Do not construct this directly.  Access it through [Cesium3DTileContent.getFeature]
 * or picking using [Scene.pick] and [Scene.pickPosition].
 * ```
 * // On mouse over, display all the properties for a feature in the console log.
 * handler.setInputAction(function(movement) {
 *     var feature = scene.pick(movement.endPosition);
 *     if (feature instanceof Cesium3DTileFeature) {
 *         var propertyNames = feature.getPropertyNames();
 *         var length = propertyNames.length;
 *         for (var i = 0; i < length; ++i) {
 *             var propertyName = propertyNames[i];
 *             console.log(propertyName + ': ' + feature.getProperty(propertyName));
 *         }
 *     }
 * }, ScreenSpaceEventType.MOUSE_MOVE);
 * ```
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html">Online Documentation</a>
 */
@JsName("\$cesium__Cesium3DTileFeature")
external class Cesium3DTileFeature {
    /**
     * Gets or sets if the feature will be shown. This is set for all features
     * when a style's show is evaluated.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#show">Online Documentation</a>
     */
    var show: Boolean

    /**
     * Gets or sets the highlight color multiplied with the feature's color.  When
     * this is white, the feature's color is not changed. This is set for all features
     * when a style's color is evaluated.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#color">Online Documentation</a>
     */
    var color: Color

    /**
     * Gets the tileset containing the feature.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#tileset">Online Documentation</a>
     */
    val tileset: Cesium3DTileset

    /**
     * All objects returned by [Scene.pick] have a `primitive` property. This returns
     * the tileset containing the feature.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#primitive">Online Documentation</a>
     */
    val primitive: Cesium3DTileset

    /**
     * Returns whether the feature contains this property. This includes properties from this feature's
     * class and inherited classes when using a batch table hierarchy.
     * @param [name] The case-sensitive name of the property.
     * @return Whether the feature contains this property.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#hasProperty">Online Documentation</a>
     */
    fun hasProperty(name: String): Boolean

    /**
     * Returns an array of property names for the feature. This includes properties from this feature's
     * class and inherited classes when using a batch table hierarchy.
     * @param [results] An array into which to store the results.
     * @return The names of the feature's properties.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#getPropertyNames">Online Documentation</a>
     */
    fun getPropertyNames(results: Array<out String>? = definedExternally): Array<out String>

    /**
     * Returns a copy of the value of the feature's property with the given name. This includes properties from this feature's
     * class and inherited classes when using a batch table hierarchy.
     * ```
     * // Display all the properties for a feature in the console log.
     * var propertyNames = feature.getPropertyNames();
     * var length = propertyNames.length;
     * for (var i = 0; i < length; ++i) {
     *     var propertyName = propertyNames[i];
     *     console.log(propertyName + ': ' + feature.getProperty(propertyName));
     * }
     * ```
     * @param [name] The case-sensitive name of the property.
     * @return The value of the property or `undefined` if the property does not exist.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#getProperty">Online Documentation</a>
     */
    fun getProperty(name: String): Any

    /**
     * Sets the value of the feature's property with the given name.
     *
     * If a property with the given name doesn't exist, it is created.
     * ```
     * var height = feature.getProperty('Height'); // e.g., the height of a building
     * ```
     * ```
     * var name = 'clicked';
     * if (feature.getProperty(name)) {
     *     console.log('already clicked');
     * } else {
     *     feature.setProperty(name, true);
     *     console.log('first click');
     * }
     * ```
     * @param [name] The case-sensitive name of the property.
     * @param [value] The value of the property that will be copied.
     * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/Cesium3DTileFeature.html#setProperty">Online Documentation</a>
     */
    fun setProperty(
        name: String,
        value: Any,
    )
}
