// Automatically generated - do not modify!

package cesium

/**
 * Asynchronously loads and parses the given URL to a CRN file or parses the raw binary data of a CRN file.
 * Returns a promise that will resolve to an object containing the image buffer, width, height and format once loaded,
 * or reject if the URL failed to load or failed to parse the data.  The data is loaded
 * using XMLHttpRequest, which means that in order to make requests to another origin,
 * the server must have Cross-Origin Resource Sharing (CORS) headers enabled.
 * ```
 * // load a single URL asynchronously
 * loadCRN('some/url').then(function(textureData) {
 *     var width = textureData.width;
 *     var height = textureData.height;
 *     var format = textureData.internalFormat;
 *     var arrayBufferView = textureData.bufferView;
 *     // use the data to create a texture
 * }).otherwise(function(error) {
 *     // an error occurred
 * });
 * ```
 * @param [resourceOrUrlOrBuffer] The URL of the binary data or an ArrayBuffer.
 * @return A promise that will resolve to the requested data when loaded. Returns undefined if `request.throttle` is true and the request does not have high enough priority.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/loadCRN.html">Online Documentation</a>
 */
external fun loadCRN(resourceOrUrlOrBuffer: Resource): kotlin.js.Promise<CompressedTextureBuffer>?

external fun loadCRN(resourceOrUrlOrBuffer: String): kotlin.js.Promise<CompressedTextureBuffer>?

external fun loadCRN(resourceOrUrlOrBuffer: org.khronos.webgl.ArrayBuffer): kotlin.js.Promise<CompressedTextureBuffer>?
