// Automatically generated - do not modify!

package cesium

/**
 * Asynchronously loads and parses the given URL to a KTX file or parses the raw binary data of a KTX file.
 * Returns a promise that will resolve to an object containing the image buffer, width, height and format once loaded,
 * or reject if the URL failed to load or failed to parse the data.  The data is loaded
 * using XMLHttpRequest, which means that in order to make requests to another origin,
 * the server must have Cross-Origin Resource Sharing (CORS) headers enabled.
 *
 * The following are part of the KTX format specification but are not supported:
 * - Big-endian files
 * - Metadata
 * - 3D textures
 * - Texture Arrays
 * - Cubemaps
 * - Mipmaps
 * ```
 * // load a single URL asynchronously
 * loadKTX('some/url').then(function(ktxData) {
 *     var width = ktxData.width;
 *     var height = ktxData.height;
 *     var format = ktxData.internalFormat;
 *     var arrayBufferView = ktxData.bufferView;
 *     // use the data to create a texture
 * }).otherwise(function(error) {
 *     // an error occurred
 * });
 * ```
 * @param [resourceOrUrlOrBuffer] The URL of the binary data or an ArrayBuffer.
 * @return A promise that will resolve to the requested data when loaded. Returns undefined if `request.throttle` is true and the request does not have high enough priority.
 * @see <a href="https://cesium.com/docs/cesiumjs-ref-doc/loadKTX.html">Online Documentation</a>
 */
external fun loadKTX(resourceOrUrlOrBuffer: Resource): kotlin.js.Promise<CompressedTextureBuffer>?

external fun loadKTX(resourceOrUrlOrBuffer: String): kotlin.js.Promise<CompressedTextureBuffer>?

external fun loadKTX(resourceOrUrlOrBuffer: org.khronos.webgl.ArrayBuffer): kotlin.js.Promise<CompressedTextureBuffer>?
