/*
 * Decompiled with CFR 0.152.
 */
package sample.tomcat.web;

import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class JasyptController {
    private static Logger logger = LoggerFactory.getLogger(JasyptController.class);
    @Autowired
    private StringEncryptor stringEncryptor;
    private static final String ENCRYPTED_VALUE_PREFIX = "ENC(";
    private static final String ENCRYPTED_VALUE_SUFFIX = ")";

    public static boolean isEncryptedValue(String value) {
        if (value == null) {
            return false;
        }
        String trimmedValue = value.trim();
        return trimmedValue.startsWith("ENC(") && trimmedValue.endsWith(")");
    }

    private static String getInnerEncryptedValue(String value) {
        return value.substring("ENC(".length(), value.length() - ")".length());
    }

    @RequestMapping(value={"/encrypt"}, method={RequestMethod.POST})
    @ResponseBody
    public String encrypt(@RequestParam(value="text") String text) {
        String encrypted = this.stringEncryptor.encrypt(text.trim());
        logger.info("ORIGINAL: " + text);
        logger.info("ENCRYPTED: " + encrypted);
        logger.info("DECRYPTED: " + this.stringEncryptor.decrypt(encrypted));
        return String.format("ENC(%s)", encrypted);
    }

    @RequestMapping(value={"/decrypt"}, method={RequestMethod.POST})
    @ResponseBody
    public String decrypt(@RequestParam(value="text") String text) {
        String decrypted = this.stringEncryptor.decrypt(JasyptController.isEncryptedValue((String)text) ? JasyptController.getInnerEncryptedValue((String)text) : text);
        logger.info("ORIGINAL: " + text);
        logger.info("DECRYPTED: " + decrypted);
        logger.info("ENCRYPTED: " + String.format("ENC(%s)", this.stringEncryptor.encrypt(decrypted)));
        return decrypted;
    }
}

