/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.handlers.inline;

import com.github.unafraid.telegrambot.bots.AbstractTelegramBot;
import com.github.unafraid.telegrambot.handlers.ICallbackQueryHandler;
import com.github.unafraid.telegrambot.handlers.ICancelHandler;
import com.github.unafraid.telegrambot.handlers.ICommandHandler;
import com.github.unafraid.telegrambot.handlers.IMessageHandler;
import com.github.unafraid.telegrambot.handlers.inline.InlineButton;
import com.github.unafraid.telegrambot.handlers.inline.InlineButtonBuilder;
import com.github.unafraid.telegrambot.handlers.inline.InlineContext;
import com.github.unafraid.telegrambot.handlers.inline.InlineMenu;
import com.github.unafraid.telegrambot.handlers.inline.InlineMenuBuilder;
import com.github.unafraid.telegrambot.handlers.inline.InlineUserData;
import com.github.unafraid.telegrambot.handlers.inline.events.IInlineCallbackEvent;
import com.github.unafraid.telegrambot.handlers.inline.events.IInlineMessageEvent;
import com.github.unafraid.telegrambot.handlers.inline.events.InlineCallbackEvent;
import com.github.unafraid.telegrambot.handlers.inline.events.InlineMessageEvent;
import com.github.unafraid.telegrambot.handlers.inline.layout.InlineRowDefinedLayout;
import com.github.unafraid.telegrambot.util.BotUtil;
import java.util.List;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.AnswerCallbackQuery;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.CallbackQuery;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.bots.AbsSender;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public abstract class AbstractInlineHandler
implements ICommandHandler,
IMessageHandler,
ICallbackQueryHandler,
ICancelHandler {
    private volatile InlineMenu defaultMenu;

    public AbstractInlineHandler() {
        this.init();
    }

    private void init() {
        InlineContext ctx = new InlineContext();
        InlineMenuBuilder builder = new InlineMenuBuilder(ctx);
        this.registerMenu(ctx, builder);
        this.defaultMenu = builder.build();
    }

    public abstract void registerMenu(InlineContext var1, InlineMenuBuilder var2);

    public boolean onCallbackQuery(AbstractTelegramBot bot, Update update, CallbackQuery query) throws TelegramApiException {
        InlineUserData userData = this.defaultMenu.getContext().getUserData(query.getFrom().getId());
        if (userData.getActiveMenu() == null) {
            return false;
        }
        InlineMenu activeMenu = userData.getActiveMenu();
        for (InlineButton button : activeMenu.getButtons()) {
            if (!button.getUUID().equals(query.getData())) continue;
            userData.setActiveButton(button);
            IInlineCallbackEvent event = button.getOnQueryCallback();
            if (event != null) {
                if (event.onCallbackEvent(new InlineCallbackEvent(button.getContext(), button, (AbsSender)bot, update, query))) {
                    InlineMenu subMenu = button.getSubMenu();
                    if (subMenu != null) {
                        bot.execute((BotApiMethod)new AnswerCallbackQuery().setCallbackQueryId(query.getId()));
                        userData.editCurrentMenu((AbsSender)bot, query.getMessage(), subMenu.getName() != null ? subMenu.getName() : "Sub menu", InlineRowDefinedLayout.DEFAULT, subMenu);
                    }
                    return true;
                }
                return false;
            }
            InlineMenu subMenu = button.getSubMenu();
            if (subMenu != null) {
                bot.execute((BotApiMethod)new AnswerCallbackQuery().setCallbackQueryId(query.getId()));
                userData.editCurrentMenu((AbsSender)bot, query.getMessage(), subMenu.getName() != null ? subMenu.getName() : "Sub menu", InlineRowDefinedLayout.DEFAULT, subMenu);
            }
            return true;
        }
        return false;
    }

    public void onCancel(AbstractTelegramBot bot, Update update, Message message) {
        if (this.defaultMenu != null) {
            this.defaultMenu.getContext().clear(message.getFrom().getId());
        }
    }

    public void onCommandMessage(AbstractTelegramBot bot, Update update, Message message, List<String> args) throws TelegramApiException {
        InlineMenu activeMenu;
        InlineUserData userData = this.defaultMenu.getContext().getUserData(message.getFrom().getId());
        if (userData.getActiveMenu() == null) {
            userData.setActiveMenu(this.defaultMenu);
        }
        if ((activeMenu = userData.getActiveMenu()) != this.defaultMenu) {
            return;
        }
        userData.sendMenu((AbsSender)bot, message, activeMenu.getName() != null ? activeMenu.getName() : "Menu", InlineRowDefinedLayout.DEFAULT, activeMenu);
    }

    public boolean onMessage(AbstractTelegramBot bot, Update update, Message message) throws TelegramApiException {
        if (this.defaultMenu == null) {
            return false;
        }
        InlineUserData userData = this.defaultMenu.getContext().getUserData(message.getFrom().getId());
        InlineButton activeButton = userData.getActiveButton();
        if (activeButton == null) {
            return false;
        }
        IInlineMessageEvent event = activeButton.getInputMessage();
        if (event != null) {
            return event.onCallbackEvent(new InlineMessageEvent(this.defaultMenu.getContext(), activeButton, (AbsSender)bot, update, message));
        }
        return false;
    }

    public InlineButton defaultClose(InlineContext context) {
        return new InlineButtonBuilder(context).name("Close").forceOnNewRow().onQueryCallback(this::handleClose).build();
    }

    public InlineButton defaultBack(InlineContext context) {
        return new InlineButtonBuilder(context).name("Back").forceOnNewRow().onQueryCallback(this::handleBack).build();
    }

    public InlineButton defaultBack(InlineContext context, InlineMenu targetMenu) {
        return new InlineButtonBuilder(context).name("Back").forceOnNewRow().onQueryCallback(event -> {
            InlineUserData userData = event.getContext().getUserData(event.getQuery().getFrom().getId());
            userData.editCurrentMenu(event.getBot(), event.getQuery().getMessage(), this.defaultMenu.getName(), InlineRowDefinedLayout.DEFAULT, targetMenu);
            return true;
        }).build();
    }

    public boolean handleClose(InlineCallbackEvent event) throws TelegramApiException {
        event.getContext().clear(event.getQuery().getFrom().getId());
        BotUtil.editMessage((AbsSender)event.getBot(), (Message)event.getQuery().getMessage(), (String)String.format("Menu closed, type in %s  to open the menu again.", this.getCommand()), (boolean)false, null);
        return true;
    }

    public boolean handleBack(InlineCallbackEvent event) throws TelegramApiException {
        InlineUserData userData = event.getContext().getUserData(event.getQuery().getFrom().getId());
        InlineMenu targetMenu = userData.getActiveMenu().getParentMenu() != null ? userData.getActiveMenu().getParentMenu() : this.defaultMenu;
        userData.editCurrentMenu(event.getBot(), event.getQuery().getMessage(), this.defaultMenu.getName(), InlineRowDefinedLayout.DEFAULT, targetMenu);
        return true;
    }

    public InlineMenu getDefaultMenu() {
        return this.defaultMenu;
    }

    public void setDefaultMenu(InlineMenu defaultMenu) {
        this.defaultMenu = Objects.requireNonNull(defaultMenu, "Default menu cannot be null!");
    }
}

