/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.handlers.inline;

import com.github.unafraid.telegrambot.handlers.inline.InlineButtonBuilder;
import com.github.unafraid.telegrambot.handlers.inline.InlineContext;
import com.github.unafraid.telegrambot.handlers.inline.InlineMenu;
import com.github.unafraid.telegrambot.handlers.inline.events.IInlineCallbackEvent;
import com.github.unafraid.telegrambot.handlers.inline.events.IInlineMessageEvent;
import java.util.UUID;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;

public class InlineButton {
    private final InlineContext context;
    private final String name;
    private final int row;
    private final boolean forceNewRow;
    private final IInlineCallbackEvent onQueryCallback;
    private final IInlineMessageEvent onInputMessage;
    private final InlineMenu subMenu;
    private final String uuid = UUID.randomUUID().toString();

    public InlineButton(InlineButtonBuilder builder) {
        this.context = builder.context;
        this.name = builder.name;
        this.row = builder.row;
        this.forceNewRow = builder.forceNewRow;
        this.onQueryCallback = builder.onQueryCallback;
        this.onInputMessage = builder.onInputMessage;
        this.subMenu = builder.subMenu;
    }

    public InlineContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public int getRow() {
        return this.row;
    }

    public boolean isForceNewRow() {
        return this.forceNewRow;
    }

    public IInlineCallbackEvent getOnQueryCallback() {
        return this.onQueryCallback;
    }

    public IInlineMessageEvent getInputMessage() {
        return this.onInputMessage;
    }

    public InlineMenu getSubMenu() {
        return this.subMenu;
    }

    public String getUUID() {
        return this.uuid;
    }

    public InlineKeyboardButton createInlineKeyboardButton() {
        return new InlineKeyboardButton().setText(this.name).setCallbackData(this.uuid);
    }
}

