/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.handlers.inline;

import com.github.unafraid.telegrambot.handlers.inline.InlineButton;
import com.github.unafraid.telegrambot.handlers.inline.InlineContext;
import com.github.unafraid.telegrambot.handlers.inline.InlineMenu;
import com.github.unafraid.telegrambot.handlers.inline.events.IInlineCallbackEvent;
import com.github.unafraid.telegrambot.handlers.inline.events.IInlineMessageEvent;
import java.util.Objects;

public class InlineButtonBuilder {
    final InlineContext context;
    String name;
    int row;
    boolean forceNewRow;
    IInlineCallbackEvent onQueryCallback;
    IInlineMessageEvent onInputMessage;
    InlineMenu subMenu;

    public InlineButtonBuilder(InlineContext context) {
        this.context = context;
    }

    public InlineButtonBuilder name(String name) {
        this.name = name;
        return this;
    }

    public InlineButtonBuilder row(int row) {
        this.row = row;
        return this;
    }

    public InlineButtonBuilder forceOnNewRow() {
        this.forceNewRow = true;
        return this;
    }

    public InlineButtonBuilder onQueryCallback(IInlineCallbackEvent onQueryCallback) {
        Objects.requireNonNull(onQueryCallback);
        this.onQueryCallback = onQueryCallback;
        return this;
    }

    public InlineButtonBuilder onInputMessage(IInlineMessageEvent onInputMessage) {
        Objects.requireNonNull(onInputMessage);
        this.onInputMessage = onInputMessage;
        return this;
    }

    public InlineButtonBuilder menu(InlineMenu subMenu) {
        if (this.subMenu != null) {
            throw new IllegalStateException("Menu already set!");
        }
        Objects.requireNonNull(subMenu);
        this.subMenu = subMenu;
        return this;
    }

    public InlineButton build() {
        return new InlineButton(this);
    }
}

