/*
 * Decompiled with CFR 0.152.
 */
package com.github.unafraid.telegrambot.handlers.inline;

import com.github.unafraid.telegrambot.handlers.inline.InlineButton;
import com.github.unafraid.telegrambot.handlers.inline.InlineMenu;
import com.github.unafraid.telegrambot.handlers.inline.layout.IInlineMenuLayout;
import com.github.unafraid.telegrambot.util.BotUtil;
import com.github.unafraid.telegrambot.util.MapUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.bots.AbsSender;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class InlineUserData {
    private final int id;
    private final MapUtil params = new MapUtil(new ConcurrentHashMap());
    private InlineMenu activeMenu;
    private InlineButton activeButton;
    private int state;

    public InlineUserData(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public InlineMenu getActiveMenu() {
        return this.activeMenu;
    }

    public void setActiveMenu(InlineMenu activeMenu) {
        this.activeMenu = activeMenu;
    }

    public InlineButton getActiveButton() {
        return this.activeButton;
    }

    public void setActiveButton(InlineButton activeButton) {
        this.activeButton = activeButton;
    }

    public MapUtil getParams() {
        return this.params;
    }

    public void sendMenu(AbsSender bot, Message message, String text, IInlineMenuLayout layout, InlineMenu menu) throws TelegramApiException {
        Objects.requireNonNull(menu);
        this.activeMenu = menu;
        InlineKeyboardMarkup markup = layout.generateLayout(this.activeMenu.getButtons());
        BotUtil.sendMessage((AbsSender)bot, (Message)message, (String)text, (boolean)false, (boolean)true, (ReplyKeyboard)markup);
    }

    public void editCurrentMenu(AbsSender bot, Message message, String text, IInlineMenuLayout layout, InlineMenu menu) throws TelegramApiException {
        Objects.requireNonNull(menu);
        if (text == null || text.trim().isEmpty()) {
            throw new IllegalStateException("Menu's name should be non empty!");
        }
        this.activeMenu = menu;
        InlineKeyboardMarkup markup = layout.generateLayout(this.activeMenu.getButtons());
        BotUtil.editMessage((AbsSender)bot, (Message)message, (String)text, (boolean)true, (InlineKeyboardMarkup)markup);
    }

    public void editCurrentMenu(AbsSender bot, Message message, IInlineMenuLayout layout, InlineMenu menu) throws TelegramApiException {
        Objects.requireNonNull(menu);
        this.editCurrentMenu(bot, message, menu.getName(), layout, menu);
    }
}

