/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.advapi;

import com.dyadicsec.advapi.SDESessionKey;
import com.dyadicsec.advapi.SDEUtils;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKPRFKey;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public final class SDEKey {
    public static final int PURPOSE_ONE_WAY = 0;
    public static final int PURPOSE_SP_ENC = -1;
    public static final int PURPOSE_OP_ENC = -2;
    public static final int PURPOSE_EMAIL_ENC = -3;
    public static final int PURPOSE_CREDIT_CARD_ENC = -4;
    public static final int PURPOSE_US_PHONE_ENC = -5;
    public static final int PURPOSE_SSN_ENC = -6;
    public static final int PURPOSE_STRING_ENC = -7;
    protected CKPRFKey prfKey = null;

    private SDEKey(CKPRFKey prfKey) {
        this.prfKey = prfKey;
    }

    private static SDEKey find(Slot slot, String name) {
        if (slot == null) {
            return null;
        }
        CKPRFKey prfKey = CKPRFKey.find(slot, name);
        if (prfKey == null) {
            return null;
        }
        return new SDEKey(prfKey);
    }

    private static SDEKey find(Slot slot, long uld) {
        if (slot == null) {
            return null;
        }
        CKPRFKey prfKey = CKPRFKey.find(slot, uld);
        if (prfKey == null) {
            return null;
        }
        return new SDEKey(prfKey);
    }

    public static SDEKey findKey(String name) {
        return SDEKey.find(Slot.getDefault(), name);
    }

    public static SDEKey findKey(String slotName, String name) {
        Slot slot = Slot.find(slotName);
        if (slot == null) {
            return null;
        }
        return SDEKey.find(slot, name);
    }

    public long getUID() throws CKException {
        return this.prfKey.getUID();
    }

    public SDEKey getPreviousKey() {
        long replacedUID = 0L;
        try {
            replacedUID = this.prfKey.getReplacedUID();
        }
        catch (CKException e) {
            return null;
        }
        return SDEKey.find(this.prfKey.getSlot(), replacedUID);
    }

    public static SDEKey findKey(long uid) {
        return SDEKey.find(Slot.getDefault(), uid);
    }

    public static SDEKey findKey(String slotName, long uid) {
        Slot slot = Slot.find(slotName);
        if (slot == null) {
            return null;
        }
        return SDEKey.find(slot, uid);
    }

    public byte[] encrypt(byte[] aad, byte[] in) throws SecurityException {
        try {
            byte[] temp = this.prfKey.encrypt(aad, in);
            byte[] out = new byte[8 + temp.length];
            Utils.uidToBytes(this.getUID(), out, 0);
            System.arraycopy(temp, 0, out, 8, temp.length);
            return out;
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public byte[] decrypt(byte[] aad, byte[] in) throws SecurityException {
        try {
            if (in.length < 8) {
                throw new SecurityException("Invalid encrypted data length");
            }
            long uid = Utils.bytesToUID(in, 0);
            SDEKey sdeKey = SDEKey.find(this.prfKey.getSlot(), uid);
            if (sdeKey == null) {
                throw new SecurityException("Key not found");
            }
            return sdeKey.prfKey.decrypt(aad, Arrays.copyOfRange(in, 8, in.length));
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    private SDESessionKey generateSessionKey(int purpose, byte[] tweak) throws SecurityException {
        int keyType = purpose == 0 ? 16 : 31;
        try {
            return new SDESessionKey(this, purpose, this.prfKey.derive(purpose, tweak, keyType, 256));
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public SDESessionKey generateSessionKey(int purpose, String tweak) throws SecurityException {
        try {
            return this.generateSessionKey(purpose, SDEUtils.generateTweak(tweak));
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptPRF(String tweak, byte[] data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(0, tweak);
            byte[] byArray = sessionKey.encryptPRF(data);
            return byArray;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptTypePreserving(String tweak, byte[] data) throws SecurityException, IllegalArgumentException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            byte[] byArray = sessionKey.encryptTypePreserving(data);
            return byArray;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptTypePreserving(String tweak, byte[] encData) throws SecurityException, IllegalArgumentException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            byte[] byArray = sessionKey.decryptTypePreserving(encData);
            return byArray;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptTypePreserving(String tweak, String data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-7, tweak);
            String string = sessionKey.encryptTypePreserving(data, true);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptTypePreserving(String tweak, String encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-7, tweak);
            String string = sessionKey.decryptTypePreserving(encData, true);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptOrderPreserving(String tweak, String data, int size) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-2, tweak);
            String string = sessionKey.encryptOrderPreserving(data, size);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptOrderPreserving(String tweak, String encDataStr) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-2, tweak);
            String string = sessionKey.decryptOrderPreserving(encDataStr);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long encryptTypePreserving(String tweak, long data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            long l = sessionKey.encryptTypePreserving(data);
            return l;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decryptTypePreserving(String tweak, long encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            long l = sessionKey.decryptTypePreserving(encData);
            return l;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encryptTypePreserving(String tweak, int data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            int n = sessionKey.encryptTypePreserving(data);
            return n;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decryptTypePreserving(String tweak, int encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            int n = sessionKey.decryptTypePreserving(encData);
            return n;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long encryptOrderPreserving(String tweak, int data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-2, tweak);
            long l = sessionKey.encryptOrderPreserving(data);
            return l;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decryptOrderPreserving(String tweak, long encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-2, tweak);
            int n = sessionKey.decryptOrderPreserving(encData);
            return n;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short encryptTypePreserving(String tweak, short data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            short s = sessionKey.encryptTypePreserving(data);
            return s;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short decryptTypePreserving(String tweak, short encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            short s = sessionKey.decryptTypePreserving(encData);
            return s;
        }
        finally {
            sessionKey.destroy();
        }
    }

    public long encryptOrderPreserving(String tweak, short data) throws SecurityException {
        return this.encryptOrderPreserving(tweak, (int)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float encryptTypePreserving(String tweak, float data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            float f = sessionKey.encryptTypePreserving(data);
            return f;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float decryptTypePreserving(String tweak, float encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            float f = sessionKey.decryptTypePreserving(encData);
            return f;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double encryptTypePreserving(String tweak, double data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            double d = sessionKey.encryptTypePreserving(data);
            return d;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double decryptTypePreserving(String tweak, double encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            double d = sessionKey.decryptTypePreserving(encData);
            return d;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date encryptTypePreserving(String tweak, Date data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Date date = sessionKey.encryptTypePreserving(data);
            return date;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date decryptTypePreserving(String tweak, Date encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Date date = sessionKey.decryptTypePreserving(encData);
            return date;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time encryptTypePreserving(String tweak, Time data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Time time = sessionKey.encryptTypePreserving(data);
            return time;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time decryptTypePreserving(String tweak, Time encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Time time = sessionKey.decryptTypePreserving(encData);
            return time;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp encryptTypePreserving(String tweak, Timestamp data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Timestamp timestamp = sessionKey.encryptTypePreserving(data);
            return timestamp;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp decryptTypePreserving(String tweak, Timestamp encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Timestamp timestamp = sessionKey.decryptTypePreserving(encData);
            return timestamp;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptOrderPreserving(String tweak, Timestamp data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-2, tweak);
            String string = sessionKey.encryptOrderPreserving(data);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp decryptOrderPreservingTS(String tweak, String encDataStr) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-2, tweak);
            Timestamp timestamp = sessionKey.decryptOrderPreservingTS(encDataStr);
            return timestamp;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encryptTypePreserving(String tweak, boolean data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            boolean bl = sessionKey.encryptTypePreserving(data);
            return bl;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decryptTypePreserving(String tweak, boolean encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            boolean bl = sessionKey.decryptTypePreserving(encData);
            return bl;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob encryptTypePreserving(String tweak, Blob data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Blob blob = sessionKey.encryptTypePreserving(data);
            return blob;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob decryptTypePreserving(String tweak, Blob encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Blob blob = sessionKey.decryptTypePreserving(encData);
            return blob;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob encryptTypePreserving(String tweak, Clob data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Clob clob = sessionKey.encryptTypePreserving(data);
            return clob;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob decryptTypePreserving(String tweak, Clob encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            Clob clob = sessionKey.decryptTypePreserving(encData);
            return clob;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal encryptTypePreserving(String tweak, BigDecimal data) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            BigDecimal bigDecimal = sessionKey.encryptTypePreserving(data);
            return bigDecimal;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal decryptTypePreserving(String tweak, BigDecimal encData) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-1, tweak);
            BigDecimal bigDecimal = sessionKey.decryptTypePreserving(encData);
            return bigDecimal;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptEMailAddress(String tweak, String in, int maxSize) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-3, tweak);
            String string = sessionKey.encryptEMailAddress(in, maxSize);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptEMailAddress(String tweak, String in) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-3, tweak);
            String string = sessionKey.decryptEMailAddress(in);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptCreditCard(String tweak, String in) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-4, tweak);
            String string = sessionKey.encryptCreditCard(in);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptCreditCard(String tweak, String in, String format) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-4, tweak);
            String string = sessionKey.encryptCreditCard(in, format);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptCreditCard(String tweak, String in) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-4, tweak);
            String string = sessionKey.decryptCreditCard(in);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptCreditCard(String tweak, String in, String format) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-4, tweak);
            String string = sessionKey.decryptCreditCard(in, format);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptUSPhone(String tweak, String in, String format) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-5, tweak);
            String string = sessionKey.encryptUSPhone(in, format);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptUSPhone(String tweak, String in, String format) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-5, tweak);
            String string = sessionKey.decryptUSPhone(in, format);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptSSN(String tweak, String in, String format) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-6, tweak);
            String string = sessionKey.encryptSSN(in, format);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decryptSSN(String tweak, String in, String format) throws SecurityException {
        SDESessionKey sessionKey = null;
        try {
            sessionKey = this.generateSessionKey(-6, tweak);
            String string = sessionKey.decryptSSN(in, format);
            return string;
        }
        finally {
            sessionKey.destroy();
        }
    }
}

