/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.advapi;

import com.dyadicsec.advapi.SDEKey;
import com.dyadicsec.advapi.SDEUtils;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKSecretKey;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class SDESessionKey {
    private int purpose;
    CKSecretKey secretKey;
    SDEKey sdeKey;
    private static final int ONEWAY_TOKEN_SIZE = 16;
    private static final int MS_PER_DAY = 86400000;

    SDESessionKey(SDEKey sdeKey, int purpose, CKSecretKey secretKey) {
        this.sdeKey = sdeKey;
        this.purpose = purpose;
        this.secretKey = secretKey;
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        if (this.secretKey == null) {
            return;
        }
        try {
            this.secretKey.destroy();
        }
        catch (CKException cKException) {
            // empty catch block
        }
        this.secretKey = null;
    }

    public byte[] getKeyMaterial() {
        try {
            return this.secretKey.getValue();
        }
        catch (CKException e) {
            return null;
        }
    }

    public SDEKey getSDEKey() {
        return this.sdeKey;
    }

    public byte[] encryptPRF(byte[] in) throws SecurityException {
        if (this.purpose != 0) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            return this.secretKey.hmacSha256(in);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String encryptPRF(String data) throws SecurityException {
        try {
            byte[] encData = this.encryptPRF(data.getBytes("UTF8"));
            return SDEUtils.bytesToStringTP(encData);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    private byte[] encryptTypePreserving(byte[] in, int bits) throws SecurityException {
        if (this.purpose != -1) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        if (in.length < 16 && bits % 2 != 0 && bits != 1) {
            throw new IllegalArgumentException("Byte array input for type preserving encryption cannot be odd and less then 16 bytes");
        }
        try {
            return this.secretKey.encryptSPE(in, bits);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public byte[] encryptTypePreserving(byte[] in) throws SecurityException {
        return this.encryptTypePreserving(in, in.length * 8);
    }

    private byte[] decryptTypePreserving(byte[] in, int bits) throws SecurityException {
        if (this.purpose != -1) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        if (in.length < 16 && bits % 2 != 0 && bits != 1) {
            throw new IllegalArgumentException("Byte array input for type preserving decryption cannot be odd and less then 16 bytes");
        }
        try {
            return this.secretKey.decryptSPE(in, bits);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public byte[] decryptTypePreserving(byte[] in) throws SecurityException {
        return this.decryptTypePreserving(in, in.length * 8);
    }

    public String encryptTypePreserving(String in, boolean BMPOnly) throws SecurityException {
        if (this.purpose != -7) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            String format = BMPOnly ? "ISO-10646-UCS-2" : "UTF-16BE";
            return this.secretKey.encryptStringFPE(in, format);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptTypePreserving(String in, boolean BMPOnly) throws SecurityException {
        if (this.purpose != -7) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            String format = BMPOnly ? "ISO-10646-UCS-2" : "UTF-16BE";
            return this.secretKey.decryptStringFPE(in, format);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String encryptOrderPreserving(String data, int size) throws SecurityException {
        try {
            byte[] dataBytes = data.getBytes("UTF8");
            dataBytes = SDEUtils.addTailing(dataBytes, (byte)0, size - dataBytes.length);
            byte[] encData = this.encryptOPE(dataBytes);
            return SDEUtils.bytesToStringOP(encData);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptOrderPreserving(String encDataStr) throws SecurityException {
        try {
            byte[] encData = SDEUtils.stringToBytesOP(encDataStr);
            byte[] data = this.decryptOPE(encData);
            data = SDEUtils.removeTailing(data, (byte)0);
            return new String(data, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    byte[] encryptOPE(byte[] in) throws SecurityException {
        if (this.purpose != -2) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            return this.secretKey.encryptOPE(in);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    byte[] decryptOPE(byte[] in) throws SecurityException {
        if (this.purpose != -2) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            return this.secretKey.decryptOPE(in);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public long encryptTypePreserving(long data) throws SecurityException {
        byte[] dataBytes = ByteBuffer.allocate(8).putLong(data).array();
        byte[] encData = this.encryptTypePreserving(dataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(encData);
        return wrapped.getLong();
    }

    public long decryptTypePreserving(long encData) throws SecurityException {
        byte[] encDataBytes = ByteBuffer.allocate(8).putLong(encData).array();
        byte[] data = this.decryptTypePreserving(encDataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        return wrapped.getLong();
    }

    public int encryptTypePreserving(int data) throws SecurityException {
        byte[] dataBytes = ByteBuffer.allocate(4).putInt(data).array();
        byte[] encData = this.encryptTypePreserving(dataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(encData);
        return wrapped.getInt();
    }

    public int decryptTypePreserving(int encData) throws SecurityException {
        byte[] encDataBytes = ByteBuffer.allocate(4).putInt(encData).array();
        byte[] data = this.decryptTypePreserving(encDataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        return wrapped.getInt();
    }

    public long encryptOrderPreserving(int data) throws SecurityException {
        byte[] dataBytes = ByteBuffer.allocate(4).putInt(data).array();
        byte[] encData = this.encryptOPE(dataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(encData);
        return wrapped.getLong();
    }

    public int decryptOrderPreserving(long encData) throws SecurityException {
        byte[] encDataBytes = ByteBuffer.allocate(8).putLong(encData).array();
        byte[] data = this.decryptOPE(encDataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        return wrapped.getInt();
    }

    public short encryptTypePreserving(short data) throws SecurityException {
        byte[] dataBytes = ByteBuffer.allocate(2).putShort(data).array();
        byte[] encData = this.encryptTypePreserving(dataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(encData);
        return wrapped.getShort();
    }

    public short decryptTypePreserving(short encData) throws SecurityException {
        byte[] encDataBytes = ByteBuffer.allocate(2).putShort(encData).array();
        byte[] data = this.decryptTypePreserving(encDataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        return wrapped.getShort();
    }

    public long encryptOrderPreserving(short data) throws SecurityException {
        return this.encryptOrderPreserving((int)data);
    }

    public float encryptTypePreserving(float data) throws SecurityException {
        byte[] dataBytes = ByteBuffer.allocate(4).putFloat(data).array();
        byte[] encData = this.encryptTypePreserving(dataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(encData);
        return wrapped.getFloat();
    }

    public float decryptTypePreserving(float encData) throws SecurityException {
        byte[] encDataBytes = ByteBuffer.allocate(4).putFloat(encData).array();
        byte[] data = this.decryptTypePreserving(encDataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        return wrapped.getFloat();
    }

    public double encryptTypePreserving(double data) throws SecurityException {
        byte[] dataBytes = ByteBuffer.allocate(8).putDouble(data).array();
        byte[] encData = this.encryptTypePreserving(dataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(encData);
        return wrapped.getDouble();
    }

    public double decryptTypePreserving(double encData) throws SecurityException {
        byte[] encDataBytes = ByteBuffer.allocate(8).putDouble(encData).array();
        byte[] data = this.decryptTypePreserving(encDataBytes);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        return wrapped.getDouble();
    }

    public Date encryptTypePreserving(Date data) throws SecurityException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCal.set(1, calendar.get(1));
        utcCal.set(2, calendar.get(2));
        utcCal.set(5, calendar.get(5));
        utcCal.set(14, 0);
        utcCal.set(13, 0);
        utcCal.set(12, 0);
        utcCal.set(11, 0);
        long dateAsLongUTC = utcCal.getTimeInMillis();
        long d = dateAsLongUTC / 86400000L;
        byte[] dataBytes = ByteBuffer.allocate(8).putLong(d).array();
        SDEUtils.reverseBytes(dataBytes);
        dataBytes = Arrays.copyOf(dataBytes, 3);
        byte[] encData = this.encryptTypePreserving(dataBytes, 20);
        SDEUtils.reverseBytes(encData);
        byte[] longData = new byte[8];
        System.arraycopy(encData, 0, longData, 5, 3);
        ByteBuffer wrapped = ByteBuffer.wrap(longData);
        long output = wrapped.getLong() * 86400000L;
        return new Date(output);
    }

    public Date decryptTypePreserving(Date encData) throws SecurityException {
        long dateAsLong = encData.getTime();
        long d = dateAsLong / 86400000L;
        byte[] encDataBytes = ByteBuffer.allocate(8).putLong(d).array();
        SDEUtils.reverseBytes(encDataBytes);
        encDataBytes = Arrays.copyOf(encDataBytes, 3);
        byte[] data = this.decryptTypePreserving(encDataBytes, 20);
        SDEUtils.reverseBytes(data);
        byte[] longData = new byte[8];
        System.arraycopy(data, 0, longData, 5, 3);
        ByteBuffer wrapped = ByteBuffer.wrap(longData);
        long output = wrapped.getLong();
        Calendar localCal = Calendar.getInstance();
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCal.setTimeInMillis(output * 86400000L);
        localCal.setTimeInMillis(0L);
        localCal.set(14, utcCal.get(14));
        localCal.set(13, utcCal.get(13));
        localCal.set(12, utcCal.get(12));
        localCal.set(11, utcCal.get(11));
        localCal.set(5, utcCal.get(5));
        localCal.set(2, utcCal.get(2));
        localCal.set(1, utcCal.get(1));
        return new Date(localCal.getTimeInMillis());
    }

    public Time encryptTypePreserving(Time data) throws SecurityException {
        Calendar localCal = Calendar.getInstance();
        localCal.setTime(data);
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCal.setTimeInMillis(0L);
        utcCal.set(14, 0);
        utcCal.set(13, 0);
        utcCal.set(12, localCal.get(12));
        utcCal.set(11, localCal.get(11));
        long timeAsLong = utcCal.getTimeInMillis() / 1000L / 60L;
        byte[] dataBytes = ByteBuffer.allocate(8).putLong(timeAsLong).array();
        SDEUtils.reverseBytes(dataBytes);
        dataBytes = Arrays.copyOf(dataBytes, 2);
        byte[] encData = this.encryptTypePreserving(dataBytes, 12);
        SDEUtils.reverseBytes(encData);
        byte[] longData = new byte[8];
        System.arraycopy(encData, 0, longData, 6, 2);
        ByteBuffer wrapped = ByteBuffer.wrap(longData);
        long output = wrapped.getLong() * 1000L;
        return new Time(output);
    }

    public Time decryptTypePreserving(Time encData) throws SecurityException {
        long timeAsLong = encData.getTime() / 1000L;
        byte[] encDataBytes = ByteBuffer.allocate(8).putLong(timeAsLong).array();
        byte[] data = new byte[8];
        SDEUtils.reverseBytes(encDataBytes);
        encDataBytes = Arrays.copyOf(encDataBytes, 2);
        data = this.decryptTypePreserving(encDataBytes, 12);
        SDEUtils.reverseBytes(data);
        byte[] longData = new byte[8];
        System.arraycopy(data, 0, longData, 6, 2);
        ByteBuffer wrapped = ByteBuffer.wrap(longData);
        long output = wrapped.getLong();
        Calendar localCal = Calendar.getInstance();
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCal.setTimeInMillis(output * 1000L * 60L);
        localCal.setTimeInMillis(0L);
        localCal.set(14, 0);
        localCal.set(13, 0);
        localCal.set(12, utcCal.get(12));
        localCal.set(11, utcCal.get(11));
        Time time = new Time(localCal.getTime().getTime());
        return time;
    }

    public Timestamp encryptTypePreserving(Timestamp data) throws SecurityException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCal.set(1, calendar.get(1));
        utcCal.set(2, calendar.get(2));
        utcCal.set(5, calendar.get(5));
        utcCal.set(14, calendar.get(14));
        utcCal.set(13, calendar.get(13));
        utcCal.set(12, calendar.get(12));
        utcCal.set(11, calendar.get(11));
        long dateAsLongUTC = utcCal.getTimeInMillis();
        byte[] dataBytes = ByteBuffer.allocate(8).putLong(dateAsLongUTC).array();
        SDEUtils.reverseBytes(dataBytes);
        dataBytes = Arrays.copyOf(dataBytes, 6);
        byte[] encData = this.encryptTypePreserving(dataBytes, 46);
        SDEUtils.reverseBytes(encData);
        byte[] longData = new byte[8];
        System.arraycopy(encData, 0, longData, 2, 6);
        ByteBuffer wrapped = ByteBuffer.wrap(longData);
        long output = wrapped.getLong();
        Timestamp date = new Timestamp(output);
        return date;
    }

    public Timestamp decryptTypePreserving(Timestamp encData) throws SecurityException {
        long dateAsLong = encData.getTime();
        byte[] encDataBytes = ByteBuffer.allocate(8).putLong(dateAsLong).array();
        SDEUtils.reverseBytes(encDataBytes);
        encDataBytes = Arrays.copyOf(encDataBytes, 6);
        byte[] data = this.decryptTypePreserving(encDataBytes, 46);
        SDEUtils.reverseBytes(data);
        byte[] longData = new byte[8];
        System.arraycopy(data, 0, longData, 2, 6);
        ByteBuffer wrapped = ByteBuffer.wrap(longData);
        long output = wrapped.getLong();
        Calendar localCal = Calendar.getInstance();
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCal.setTimeInMillis(output);
        localCal.setTimeInMillis(0L);
        localCal.set(14, utcCal.get(14));
        localCal.set(13, utcCal.get(13));
        localCal.set(12, utcCal.get(12));
        localCal.set(11, utcCal.get(11));
        localCal.set(5, utcCal.get(5));
        localCal.set(2, utcCal.get(2));
        localCal.set(1, utcCal.get(1));
        Timestamp date = new Timestamp(localCal.getTimeInMillis());
        return date;
    }

    public String encryptOrderPreserving(Timestamp data) throws SecurityException {
        long time = data.getTime();
        int nanos = data.getNanos();
        ByteBuffer encDataBytesBuffer = ByteBuffer.allocate(12);
        encDataBytesBuffer.putLong(0, time);
        encDataBytesBuffer.putInt(8, nanos);
        byte[] dataBytes = encDataBytesBuffer.array();
        byte[] encData = this.encryptOPE(dataBytes);
        return SDEUtils.bytesToStringOP(encData);
    }

    public Timestamp decryptOrderPreservingTS(String encDataStr) throws SecurityException {
        byte[] encData = SDEUtils.stringToBytesOP(encDataStr);
        byte[] data = this.decryptOPE(encData);
        ByteBuffer wrapped = ByteBuffer.wrap(data);
        long time = wrapped.getLong(0);
        int nanos = wrapped.getInt(8);
        Timestamp ts = new Timestamp(time);
        ts.setNanos(nanos);
        return ts;
    }

    public boolean encryptTypePreserving(boolean data) throws SecurityException {
        byte[] in = new byte[]{data ? (byte)1 : 0};
        return this.encryptTypePreserving(in, 1)[0] != 0;
    }

    public boolean decryptTypePreserving(boolean encData) throws SecurityException {
        byte[] in = new byte[]{encData ? (byte)1 : 0};
        return this.decryptTypePreserving(in, 1)[0] != 0;
    }

    public Blob encryptTypePreserving(Blob data) throws SecurityException {
        try {
            byte[] enc = this.encryptTypePreserving(data.getBytes(1L, (int)data.length()));
            return new SerialBlob(enc);
        }
        catch (SQLException e) {
            throw new SecurityException(e);
        }
    }

    public Blob decryptTypePreserving(Blob encData) throws SecurityException {
        try {
            byte[] data = this.decryptTypePreserving(encData.getBytes(1L, (int)encData.length()));
            return new SerialBlob(data);
        }
        catch (SQLException e) {
            throw new SecurityException(e);
        }
    }

    public Clob encryptTypePreserving(Clob data) throws SecurityException {
        try {
            String enc = this.encryptTypePreserving(data.getSubString(1L, (int)data.length()), true);
            return new SerialClob(enc.toCharArray());
        }
        catch (SQLException e) {
            throw new SecurityException(e);
        }
    }

    public Clob decryptTypePreserving(Clob encData) throws SecurityException {
        try {
            String data = this.decryptTypePreserving(encData.getSubString(1L, (int)encData.length()), true);
            return new SerialClob(data.toCharArray());
        }
        catch (SQLException e) {
            throw new SecurityException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal encryptTypePreserving(BigDecimal data) throws SecurityException {
        try {
            int scale = data.scale();
            BigInteger bi = data.unscaledValue();
            boolean bNegative = bi.signum() == -1;
            bi = bi.abs();
            byte[] biBytes = bi.toByteArray();
            int biBytesLength = biBytes.length;
            if (biBytesLength > 12) {
                if (biBytesLength != 13 || biBytes[0] != 0) throw new IllegalArgumentException("Value encryption is not supported");
                byte[] newBytes = new byte[12];
                System.arraycopy(biBytes, 1, newBytes, 0, 12);
                biBytes = newBytes;
            } else {
                biBytes = SDEUtils.addLeading(biBytes, (byte)0, 12 - biBytesLength);
            }
            byte[] enc = this.encryptTypePreserving(biBytes);
            enc = SDEUtils.addLeading(enc, (byte)0, 1);
            BigInteger encBi = new BigInteger(enc);
            if (!bNegative) return new BigDecimal(encBi, scale);
            encBi = encBi.negate();
            return new BigDecimal(encBi, scale);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal decryptTypePreserving(BigDecimal encData) throws SecurityException {
        try {
            int scale = encData.scale();
            BigInteger bi = encData.unscaledValue();
            boolean bNegative = bi.signum() == -1;
            bi = bi.abs();
            byte[] biBytes = bi.toByteArray();
            int biBytesLength = biBytes.length;
            if (biBytesLength > 12) {
                if (biBytesLength != 13 || biBytes[0] != 0) throw new IllegalArgumentException("Value encryption is not supported");
                byte[] newBytes = new byte[12];
                System.arraycopy(biBytes, 1, newBytes, 0, 12);
                biBytes = newBytes;
            } else {
                biBytes = SDEUtils.addLeading(biBytes, (byte)0, 12 - biBytesLength);
            }
            byte[] data = this.decryptTypePreserving(biBytes);
            data = SDEUtils.addLeading(data, (byte)0, 1);
            BigInteger dataBi = new BigInteger(data);
            if (!bNegative) return new BigDecimal(dataBi, scale);
            dataBi = dataBi.negate();
            return new BigDecimal(dataBi, scale);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public String encryptEMailAddress(String in, int maxLen) throws SecurityException {
        if (this.purpose != -3) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.encryptFPE(1, null, maxLen, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptEMailAddress(String in) throws SecurityException {
        if (this.purpose != -3) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.decryptFPE(1, null, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String encryptCreditCard(String in) throws SecurityException {
        if (this.purpose != -4) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.encryptFPE(2, null, 0, inBuf);
            if (outBuf == null) {
                throw new SecurityException("encryptCreditCard failed");
            }
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String encryptCreditCard(String in, String format) throws SecurityException {
        if (this.purpose != -4) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.encryptFPE(2, format.toCharArray(), 0, inBuf);
            if (outBuf == null) {
                throw new SecurityException("encryptCreditCard failed");
            }
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptCreditCard(String in) throws SecurityException {
        if (this.purpose != -4) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.decryptFPE(2, null, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptCreditCard(String in, String format) throws SecurityException {
        if (this.purpose != -4) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.decryptFPE(2, format.toCharArray(), inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String encryptUSPhone(String in, String format) throws SecurityException {
        if (this.purpose != -5) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            char[] formatChars = format == null ? null : format.toCharArray();
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.encryptFPE(3, formatChars, 0, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptUSPhone(String in, String format) throws SecurityException {
        if (this.purpose != -5) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            char[] formatChars = format == null ? null : format.toCharArray();
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.decryptFPE(3, formatChars, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String encryptSSN(String in, String format) throws SecurityException {
        if (this.purpose != -6) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            char[] formatChars = format == null ? null : format.toCharArray();
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.encryptFPE(4, formatChars, 0, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }

    public String decryptSSN(String in, String format) throws SecurityException {
        if (this.purpose != -6) {
            throw new IllegalArgumentException("Invalid purpose");
        }
        try {
            char[] formatChars = format == null ? null : format.toCharArray();
            byte[] inBuf = in.getBytes("UTF-8");
            byte[] outBuf = this.secretKey.decryptFPE(4, formatChars, inBuf);
            return new String(outBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
        catch (CKException e) {
            throw new SecurityException(e);
        }
    }
}

