/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.advapi;

import com.dyadicsec.advapi.Base64;
import java.io.UnsupportedEncodingException;

class SDEUtils {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    SDEUtils() {
    }

    static byte[] generateTweak(String tweak) throws UnsupportedEncodingException {
        byte[] tweakBytes = tweak.getBytes("UTF8");
        return tweakBytes;
    }

    static byte[] addLeading(byte[] biBytes, byte value, int count) {
        int biBytesLength = biBytes.length;
        byte[] arr = new byte[biBytesLength + count];
        System.arraycopy(biBytes, 0, arr, count, biBytesLength);
        for (int i = 0; i < count; ++i) {
            arr[i] = value;
        }
        biBytes = arr;
        return biBytes;
    }

    static byte[] addTailing(byte[] biBytes, byte value, int count) {
        int biBytesLength = biBytes.length;
        byte[] arr = new byte[biBytesLength + count];
        System.arraycopy(biBytes, 0, arr, 0, biBytesLength);
        for (int i = 0; i < count; ++i) {
            arr[biBytesLength + i] = value;
        }
        biBytes = arr;
        return biBytes;
    }

    static byte[] removeTailing(byte[] biBytes, byte value) {
        int i = 0;
        for (i = 0; i < biBytes.length && biBytes[i] != 0; ++i) {
        }
        byte[] arr = new byte[i];
        System.arraycopy(biBytes, 0, arr, 0, i);
        biBytes = arr;
        return biBytes;
    }

    static byte[] removeLeading(byte[] biBytes, byte value, boolean removeOnlyFirst) {
        int biBytesLength = biBytes.length;
        int i = 0;
        for (i = 0; !(i >= biBytesLength || removeOnlyFirst && i > 0 || biBytes[i] != value); ++i) {
        }
        if (i > 0) {
            byte[] arr = new byte[biBytesLength - i];
            System.arraycopy(biBytes, i, arr, 0, biBytesLength - i);
            biBytes = arr;
        }
        return biBytes;
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static byte[] hexStringToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static String bytesToStringTP(byte[] bytes) {
        String string = Base64.byteArrayToAltBase64(bytes);
        if (string.endsWith("==")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static byte[] stringToBytesTP(String string) {
        return Base64.base64ToByteArray(string.trim());
    }

    static String bytesToStringOP(byte[] bytes) {
        return SDEUtils.bytesToHex(bytes);
    }

    static byte[] stringToBytesOP(String string) {
        return SDEUtils.hexStringToBytes(string);
    }

    static void reverseBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte temp = bytes[i];
            bytes[i] = bytes[bytes.length - i - 1];
            bytes[bytes.length - i - 1] = temp;
        }
    }
}

