/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.cryptoki;

public class CKR_Exception
extends Exception {
    public int errorCode;
    public String functionName;

    @Override
    public String getMessage() {
        if (this.functionName == null) {
            return "Library errorCode=0x" + Integer.toHexString(this.errorCode);
        }
        return "Library." + this.functionName + " failed, errorCode=0x" + Integer.toHexString(this.errorCode);
    }

    CKR_Exception(int errorCode, Exception src) {
        super(src);
        this.errorCode = errorCode;
    }

    CKR_Exception(int errorCode) {
        this.errorCode = errorCode;
    }

    CKR_Exception(int errorCode, String functionName) {
        this.errorCode = errorCode;
    }

    static void check(long rv) throws CKR_Exception {
        int errorCode = (int)(rv >> 32);
        if (errorCode != 0) {
            throw new CKR_Exception(errorCode);
        }
    }

    static void check(long rv, String function) throws CKR_Exception {
        int errorCode = (int)(rv >> 32);
        if (errorCode != 0) {
            throw new CKR_Exception(errorCode, function);
        }
    }
}

