/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.pkcs11.Slot;
import java.util.Map;

public abstract class CKKey
extends CKObject {
    int keyType = -1;

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 268);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.policy.setDerive(template.get(268).toBool());
    }

    void generateKeyPair(Slot slot, int mechType, CK_ATTRIBUTE[] pubTemplate, CK_ATTRIBUTE[] prvTemplate) throws CKException {
        if (slot == null) {
            slot = Slot.getDefault();
        }
        this.handle = slot.generateKeyPair(mechType, pubTemplate, prvTemplate);
        this.slot = slot;
    }

    void generateKey(Slot slot, int mechType, CK_ATTRIBUTE[] template) throws CKException {
        if (slot == null) {
            slot = Slot.getDefault();
        }
        this.handle = slot.generateKey(mechType, template);
        this.slot = slot;
    }

    public int getKeyType() throws CKException {
        if (this.keyType == -1) {
            this.read();
        }
        return this.keyType;
    }

    public <T extends CKKey> T derive(Class<T> c, CK_MECHANISM mechanism, CK_ATTRIBUTE[] t) throws CKException {
        return (T)((CKKey)this.slot.newObject(c, this.slot.deriveKey(mechanism, this.handle, t)));
    }

    public <T extends CKKey> T unwrap(Class<T> c, CK_MECHANISM mechanism, byte[] in, CK_ATTRIBUTE[] template) throws CKException {
        return this.unwrap(c, mechanism, in, 0, in.length, template);
    }

    public <T extends CKKey> T unwrap(Class<T> c, CK_MECHANISM mechanism, byte[] in, int inOffset, int inLen, CK_ATTRIBUTE[] template) throws CKException {
        return (T)((CKKey)this.slot.newObject(c, this.slot.unwrapKey(mechanism, this.handle, in, inOffset, inLen, template)));
    }

    public byte[] wrap(CK_MECHANISM mechanism, CKKey key, int outLen) throws CKException {
        return this.slot.persistentSession.wrap(mechanism, this, key, outLen);
    }

    public Session encryptInit(CK_MECHANISM mechanism) throws CKException {
        Session session = this.slot.getSession();
        try {
            session.encryptInit(mechanism, this);
        }
        catch (CKException e) {
            session.close();
            throw e;
        }
        return session;
    }

    public Session decryptInit(CK_MECHANISM mechanism) throws CKException {
        Session session = this.slot.getSession();
        try {
            session.decryptInit(mechanism, this);
        }
        catch (CKException e) {
            session.close();
            throw e;
        }
        return session;
    }

    public Session signInit(CK_MECHANISM mechanism) throws CKException {
        Session session = this.slot.getSession();
        try {
            session.signInit(mechanism, this);
        }
        catch (CKException e) {
            session.close();
            throw e;
        }
        return session;
    }

    public Session verifyInit(CK_MECHANISM mechanism) throws CKException {
        Session session = this.slot.getSession();
        try {
            session.verifyInit(mechanism, this);
        }
        catch (CKException e) {
            session.close();
            throw e;
        }
        return session;
    }

    public byte[] encrypt(CK_MECHANISM mechanism, byte[] in, int outLen) throws CKException {
        return Session.encrypt(mechanism, this, in, outLen);
    }

    public byte[] decrypt(CK_MECHANISM mechanism, byte[] in, int outLen) throws CKException {
        return Session.decrypt(mechanism, this, in, outLen);
    }

    public byte[] sign(CK_MECHANISM mechanism, byte[] in, int outLen) throws CKException {
        return Session.sign(mechanism, this, in, outLen);
    }

    public boolean verify(CK_MECHANISM mechanism, byte[] in, byte[] signature) throws CKException {
        return Session.verify(mechanism, this, in, signature);
    }

    public static int getGenerateMechanism(int keyType) {
        switch (keyType) {
            case 0: {
                return 0;
            }
            case 3: {
                return 4160;
            }
            case -2147454713: {
                return -2147451310;
            }
            case -2147454717: {
                return -2147451374;
            }
            case -2147454719: {
                return -2147451358;
            }
            case 31: {
                return 4224;
            }
            case -2147454715: {
                return -2147451326;
            }
            case -2147454716: {
                return -2147451390;
            }
            case 21: {
                return 305;
            }
            case 16: {
                return 848;
            }
            case -2147454712: {
                return -2147451262;
            }
        }
        return -1;
    }

    public CKKey rekey() throws CKException {
        int genMechanism = CKKey.getGenerateMechanism(this.keyType);
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, true), new CK_ATTRIBUTE(2, true), new CK_ATTRIBUTE(0, this.clazz), new CK_ATTRIBUTE(256, this.getKeyType()), new CK_ATTRIBUTE(-2147454459, this.getUID())};
        int newHandle = this.slot.generateKey(genMechanism, t);
        return (CKKey)this.slot.newObject(newHandle, this.clazz, this.getKeyType());
    }
}

