/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKPublicKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import java.util.Map;

public final class CKLIMAPublicKey
extends CKPublicKey {
    byte[] value = null;

    CKLIMAPublicKey() {
        this.keyType = -2147454713;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, -2147454457);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.value = template.get(-2147454457).getValue();
    }

    public byte[] getValue() throws CKException {
        if (this.value == null) {
            this.read();
        }
        return this.value;
    }

    public static CKLIMAPublicKey create(Slot slot, String name, Policy policy, byte[] value) throws CKException {
        if (policy == null) {
            policy = CKPublicKey.getDefaultPolicy();
        }
        CKLIMAPublicKey key = new CKLIMAPublicKey();
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0, 2), new CK_ATTRIBUTE(256, -2147454713), new CK_ATTRIBUTE(-2147454457, value), new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(260, policy.cka_encrypt), new CK_ATTRIBUTE(262, policy.cka_wrap)};
        key.create(slot, t);
        key.policy = policy;
        key.value = value;
        key.name = name;
        return key;
    }

    public byte[] encrypt(byte[] in) throws CKException {
        return this.encrypt(new CK_MECHANISM(-2147451311), in, 0);
    }
}

