/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.pkcs11.CKRSAPublicKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;

public final class CKRSAPrivateKey
extends CKPrivateKey {
    int bitSize = 0;
    BigInteger N = null;
    BigInteger E = null;
    CKRSAPublicKey pubKey = null;

    CKRSAPrivateKey() {
        this.keyType = 0;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 290);
        this.addReadTemplate(template, 288);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        byte[] modulus = template.get(288).getValue();
        this.bitSize = modulus.length * 8;
        this.E = new BigInteger(1, template.get(290).getValue());
        this.N = new BigInteger(1, modulus);
    }

    public BigInteger getE() throws CKException {
        if (this.E == null) {
            this.read();
        }
        return this.E;
    }

    public BigInteger getN() throws CKException {
        if (this.N == null) {
            this.read();
        }
        return this.N;
    }

    public int getBitSize() throws CKException {
        if (this.bitSize == 0) {
            this.read();
        }
        return this.bitSize;
    }

    public CKRSAPublicKey getPublicKey() throws CKException {
        if (this.pubKey == null) {
            this.pubKey = CKRSAPublicKey.create(this.slot, null, null, this.getN(), this.getE());
        }
        return this.pubKey;
    }

    public static CK_ATTRIBUTE[] getUnwrapTemplate(String name, Policy policy) {
        if (policy == null) {
            policy = new Policy();
        }
        return new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, 0), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(258, Utils.name2id(name))};
    }

    public static CKRSAPrivateKey generate(Slot slot, String name, Policy policy, int bitsSize) throws CKException {
        if (policy == null) {
            policy = new Policy();
        }
        CKRSAPrivateKey key = new CKRSAPrivateKey();
        CK_ATTRIBUTE[] tPrv = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, 0), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        CK_ATTRIBUTE[] tPub = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, false), new CK_ATTRIBUTE(0, 2), new CK_ATTRIBUTE(256, 0), new CK_ATTRIBUTE(289, bitsSize)};
        key.generateKeyPair(slot, 0, tPub, tPrv);
        key.bitSize = bitsSize;
        key.policy = policy;
        key.name = name;
        return key;
    }

    public static CKRSAPrivateKey create(Slot slot, String name, Policy policy, BigInteger N, BigInteger E, BigInteger D, BigInteger P, BigInteger Q, BigInteger DP, BigInteger DQ, BigInteger QINV) throws CKException {
        if (policy == null) {
            policy = new Policy();
        }
        CKRSAPrivateKey key = new CKRSAPrivateKey();
        byte[] NBuf = Utils.bigInt2Bytes(N, 0);
        int keySize = NBuf.length;
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, 0), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(288, NBuf), new CK_ATTRIBUTE(290, E.toByteArray()), new CK_ATTRIBUTE(291, Utils.bigInt2Bytes(D, keySize)), new CK_ATTRIBUTE(292, Utils.bigInt2Bytes(P, keySize / 2)), new CK_ATTRIBUTE(293, Utils.bigInt2Bytes(Q, keySize / 2)), new CK_ATTRIBUTE(294, Utils.bigInt2Bytes(DP, keySize / 2)), new CK_ATTRIBUTE(295, Utils.bigInt2Bytes(DQ, keySize / 2)), new CK_ATTRIBUTE(296, Utils.bigInt2Bytes(QINV, keySize / 2)), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.create(slot, t);
        key.bitSize = keySize * 8;
        key.policy = policy;
        key.name = name;
        key.E = E;
        key.N = N;
        return key;
    }

    public static CKRSAPrivateKey find(Slot slot, String name) {
        return (CKRSAPrivateKey)CKObject.find(slot, 3, 0, name);
    }

    public static CKRSAPrivateKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKRSAPrivateKey.class, uid);
    }

    public static ArrayList<CKRSAPrivateKey> list(Slot slot) {
        return CKObject.list(slot, CKRSAPrivateKey.class, 3, 0);
    }

    public byte[] sign(int mechanism, byte[] in) throws CKException {
        return this.sign(new CK_MECHANISM(mechanism), in);
    }

    public byte[] sign(CK_MECHANISM mechanism, byte[] in) throws CKException {
        return this.sign(mechanism, in, this.getBitSize() / 8);
    }

    public byte[] decrypt(int mechanism, byte[] in) throws CKException {
        return this.decrypt(new CK_MECHANISM(mechanism), in, this.getBitSize() / 8);
    }

    public byte[] decrypt(CK_MECHANISM mechanism, byte[] in) throws CKException {
        return this.decrypt(mechanism, in, this.getBitSize() / 8);
    }
}

