/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public final class DER {
    public static final byte TAG_INTEGER = 2;
    public static final byte TAG_OCTETSTRING = 4;
    public static final byte TAG_SEQUENCE = 48;

    public static byte[] cat(byte[] ... list) {
        int size = 0;
        for (byte[] src : list) {
            size += src.length;
        }
        byte[] out = new byte[size];
        int offset = 0;
        for (int i = 0; i < list.length; ++i) {
            byte[] src;
            src = list[i];
            System.arraycopy(list[i], 0, out, offset, src.length);
            offset += src.length;
        }
        return out;
    }

    public static byte[] encode(byte tag, byte[] data) {
        int outLen = 2 + data.length;
        if (data.length > 127) {
            ++outLen;
        }
        if (data.length > 256) {
            ++outLen;
        }
        byte[] out = new byte[outLen];
        out[0] = tag;
        if (data.length <= 127) {
            out[1] = (byte)data.length;
        } else if (data.length < 256) {
            out[1] = -127;
            out[2] = (byte)data.length;
        } else {
            out[1] = -126;
            out[2] = (byte)(data.length >> 8);
            out[3] = (byte)data.length;
        }
        System.arraycopy(data, 0, out, outLen - data.length, data.length);
        return out;
    }

    public static byte[] encode(BigInteger value) {
        return DER.encode((byte)2, value.toByteArray());
    }

    public static byte[] decode(byte tag, byte[] data) throws IOException {
        int n = data.length;
        int q = 0;
        if (n == 0 || data[q++] != tag) {
            throw new IOException("DER format error");
        }
        if (--n == 0) {
            throw new IOException("DER format error");
        }
        int s = data[q++] & 0xFF;
        --n;
        if ((s & 0x80) != 0) {
            int slen = s & 0x7F;
            if (n < slen) {
                throw new IOException("DER format error");
            }
            n -= slen;
            s = 0;
            for (int i = 0; i < slen; ++i) {
                s <<= 8;
                s |= data[q++] & 0xFF;
            }
        }
        if (n != s) {
            throw new IOException("DER format error");
        }
        return Arrays.copyOfRange(data, q, data.length);
    }
}

