/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.CK_SESSION_INFO;
import com.dyadicsec.pkcs11.CK_ULONG_PTR;
import com.dyadicsec.pkcs11.Library;
import com.dyadicsec.pkcs11.Slot;
import java.security.ProviderException;
import java.util.Arrays;

public final class Session {
    int handle = 0;
    private int slotID = -1;
    private Slot slot = null;
    boolean operationInProgress = false;

    public boolean isValid() {
        return this.handle != 0;
    }

    protected void finalize() {
        this.close();
    }

    Session(int slotID, int handle) {
        this.slotID = slotID;
        this.handle = handle;
    }

    Session(Slot slot, int handle) {
        this.slot = slot;
        this.slotID = slot.id;
        this.handle = handle;
    }

    public Session() {
    }

    public int getSlotID() {
        return this.slotID;
    }

    public static Session open(int slotID) {
        long rvLong = Library.C_OpenSession(slotID, 6);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new ProviderException("Error opening PKCS#11 session: rv=" + rv);
        }
        return new Session(slotID, Library.rvValue(rvLong));
    }

    public void close() {
        if (this.handle != 0) {
            this.C_CloseSession(this.handle);
        }
        this.handle = 0;
    }

    public int C_Login(int userType, char[] password) {
        return this.C_Login(this.handle, userType, password);
    }

    public int C_Logout() {
        return this.C_Logout(this.handle);
    }

    public int C_GetSessionInfo(CK_SESSION_INFO info) {
        return this.C_GetSessionInfo(this.handle, info);
    }

    public long C_CreateObject(CK_ATTRIBUTE[] template) {
        return this.C_CreateObject(this.handle, template);
    }

    public int C_DestroyObject(int object) {
        return this.C_DestroyObject(this.handle, object);
    }

    public long C_GenerateKey(CK_MECHANISM mechanism, CK_ATTRIBUTE[] template) {
        return this.C_GenerateKey(this.handle, mechanism, template);
    }

    public long C_GenerateKeyPair(CK_MECHANISM mechanism, CK_ATTRIBUTE[] pubTemplate, CK_ATTRIBUTE[] prvTemplate, CK_ULONG_PTR pubKey) {
        return this.C_GenerateKeyPair(this.handle, mechanism, pubTemplate, prvTemplate, pubKey);
    }

    public int C_SetAttributeValue(int object, CK_ATTRIBUTE[] template) {
        return this.C_SetAttributeValue(this.handle, object, template);
    }

    int initOperation(int rv) {
        if (rv == 0) {
            this.operationInProgress = true;
        }
        return rv;
    }

    int finalOperation(byte[] out, int rv) {
        if (rv == 336) {
            return rv;
        }
        if (rv != 0 || out != null) {
            this.operationInProgress = false;
        }
        return rv;
    }

    public int C_FindObjectsInit(CK_ATTRIBUTE[] template) {
        return this.initOperation(this.C_FindObjectsInit(this.handle, template));
    }

    public long C_FindObjects(int[] objects) {
        return this.C_FindObjects(this.handle, objects);
    }

    public int C_FindObjectsFinal() {
        int rv = this.C_FindObjectsFinal(this.handle);
        if (rv == 0) {
            this.operationInProgress = false;
        }
        return rv;
    }

    public int C_EncryptInit(CK_MECHANISM mechanism, int key) {
        return this.initOperation(this.C_EncryptInit(this.handle, mechanism, key));
    }

    public long C_Encrypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        long rvLong = this.C_Encrypt(this.handle, in, inOffset, inLen, out, outOffset);
        this.finalOperation(out, Library.rvErr(rvLong));
        return rvLong;
    }

    public long C_EncryptUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        return this.C_EncryptUpdate(this.handle, in, inOffset, inLen, out, outOffset);
    }

    public long C_EncryptFinal(byte[] out, int outOffset) {
        long rvLong = this.C_EncryptFinal(this.handle, out, outOffset);
        this.finalOperation(out, Library.rvErr(rvLong));
        return rvLong;
    }

    public int C_DecryptInit(CK_MECHANISM mechanism, int key) {
        return this.initOperation(this.C_DecryptInit(this.handle, mechanism, key));
    }

    public long C_Decrypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        long rvLong = this.C_Decrypt(this.handle, in, inOffset, inLen, out, outOffset);
        this.finalOperation(out, Library.rvErr(rvLong));
        return rvLong;
    }

    public long C_DecryptUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        return this.C_DecryptUpdate(this.handle, in, inOffset, inLen, out, outOffset);
    }

    public long C_DecryptFinal(byte[] out, int outOffset) {
        long rvLong = this.C_DecryptFinal(this.handle, out, outOffset);
        this.finalOperation(out, Library.rvErr(rvLong));
        return rvLong;
    }

    public int C_SignInit(CK_MECHANISM mechanism, int key) {
        return this.initOperation(this.C_SignInit(this.handle, mechanism, key));
    }

    public long C_Sign(byte[] in, int inOffset, int inLen, byte[] signature) {
        long rvLong = this.C_Sign(this.handle, in, inOffset, inLen, signature);
        this.finalOperation(signature, Library.rvErr(rvLong));
        return rvLong;
    }

    public int C_SignUpdate(byte[] in, int inOffset, int inLen) {
        return this.C_SignUpdate(this.handle, in, inOffset, inLen);
    }

    public long C_SignFinal(byte[] signature) {
        long rvLong = this.C_SignFinal(this.handle, signature);
        this.finalOperation(signature, Library.rvErr(rvLong));
        return rvLong;
    }

    public int C_VerifyInit(CK_MECHANISM mechanism, int key) {
        return this.initOperation(this.C_VerifyInit(this.handle, mechanism, key));
    }

    public int C_Verify(byte[] in, int inOffset, int inLen, byte[] signature) {
        return this.finalOperation(signature, this.C_Verify(this.handle, in, inOffset, inLen, signature));
    }

    public int C_VerifyUpdate(byte[] in, int inOffset, int inLen) {
        return this.C_VerifyUpdate(this.handle, in, inOffset, inLen);
    }

    public int C_VerifyFinal(byte[] signature) {
        return this.finalOperation(signature, this.C_VerifyFinal(this.handle, signature));
    }

    public long C_DeriveKey(CK_MECHANISM mechanism, int key, CK_ATTRIBUTE[] t) {
        return this.C_DeriveKey(this.handle, mechanism, key, t);
    }

    public long C_WrapKey(CK_MECHANISM mechanism, int wrappingKey, int key, byte[] out, int outOffset) {
        return this.C_WrapKey(this.handle, mechanism, wrappingKey, key, out, outOffset);
    }

    public long C_UnwrapKey(CK_MECHANISM mechanism, int unwrappingKey, byte[] in, int inOffset, int inLen, CK_ATTRIBUTE[] template) {
        return this.C_UnwrapKey(this.handle, mechanism, unwrappingKey, in, inOffset, inLen, template);
    }

    public int C_GenerateRandom(byte[] out, int outOffset, int outLen) {
        return this.C_GenerateRandom(this.handle, out, outOffset, outLen);
    }

    private native int C_CloseSession(int var1);

    private native int C_Login(int var1, int var2, char[] var3);

    private native int C_Logout(int var1);

    private native int C_GetSessionInfo(int var1, CK_SESSION_INFO var2);

    private native long C_CreateObject(int var1, CK_ATTRIBUTE[] var2);

    private native int C_DestroyObject(int var1, int var2);

    private native int C_GenerateRandom(int var1, byte[] var2, int var3, int var4);

    private native long C_GenerateKey(int var1, CK_MECHANISM var2, CK_ATTRIBUTE[] var3);

    private native long C_GenerateKeyPair(int var1, CK_MECHANISM var2, CK_ATTRIBUTE[] var3, CK_ATTRIBUTE[] var4, CK_ULONG_PTR var5);

    private native int C_SetAttributeValue(int var1, int var2, CK_ATTRIBUTE[] var3);

    private native int C_FindObjectsInit(int var1, CK_ATTRIBUTE[] var2);

    private native long C_FindObjects(int var1, int[] var2);

    private native int C_FindObjectsFinal(int var1);

    private native int C_EncryptInit(int var1, CK_MECHANISM var2, int var3);

    private native long C_Encrypt(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private native long C_EncryptUpdate(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private native long C_EncryptFinal(int var1, byte[] var2, int var3);

    private native int C_DecryptInit(int var1, CK_MECHANISM var2, int var3);

    private native long C_Decrypt(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private native long C_DecryptUpdate(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private native long C_DecryptFinal(int var1, byte[] var2, int var3);

    private native int C_SignInit(int var1, CK_MECHANISM var2, int var3);

    private native long C_Sign(int var1, byte[] var2, int var3, int var4, byte[] var5);

    private native int C_SignUpdate(int var1, byte[] var2, int var3, int var4);

    private native long C_SignFinal(int var1, byte[] var2);

    private native int C_VerifyInit(int var1, CK_MECHANISM var2, int var3);

    private native int C_Verify(int var1, byte[] var2, int var3, int var4, byte[] var5);

    private native int C_VerifyUpdate(int var1, byte[] var2, int var3, int var4);

    private native int C_VerifyFinal(int var1, byte[] var2);

    private native long C_DeriveKey(int var1, CK_MECHANISM var2, int var3, CK_ATTRIBUTE[] var4);

    private native long C_WrapKey(int var1, CK_MECHANISM var2, int var3, int var4, byte[] var5, int var6);

    private native long C_UnwrapKey(int var1, CK_MECHANISM var2, int var3, byte[] var4, int var5, int var6, CK_ATTRIBUTE[] var7);

    private native int C_GetAttributeValueSize(int var1, int var2, int[] var3);

    private native int C_GetAttributeValueData(int var1, int var2, CK_ATTRIBUTE[] var3);

    private native long DYC_SelfSignX509(int var1, int var2, int var3, char[] var4, byte[] var5, int var6, byte[] var7);

    public byte[] DYC_SelfSignX509(int object, int mechanism, char[] subject, byte[] serial, int days) throws CKException {
        long rvLong = this.DYC_SelfSignX509(this.handle, object, mechanism, subject, serial, days, null);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("DYC_SelfSignX509", rv);
        }
        int length = Library.rvValue(rvLong);
        byte[] out = new byte[length];
        this.DYC_SelfSignX509(this.handle, object, mechanism, subject, serial, days, out);
        return out;
    }

    public int C_GetAttributeSize(int object, int attribute, CK_ULONG_PTR pOutLen) {
        int[] templateInfo = new int[]{attribute};
        int rv = this.C_GetAttributeValueSize(this.handle, object, templateInfo);
        if (rv != 0) {
            return rv;
        }
        pOutLen.value = templateInfo[0];
        return 0;
    }

    public int C_GetAttributeValue(int object, CK_ATTRIBUTE[] template) {
        boolean allKnownSize = true;
        for (CK_ATTRIBUTE a : template) {
            if (CK_ATTRIBUTE.isBool(a.type) && CK_ATTRIBUTE.isInt(a.type)) continue;
            allKnownSize = false;
            break;
        }
        if (!allKnownSize) {
            int[] templateInfo = new int[template.length];
            for (int i = 0; i < template.length; ++i) {
                templateInfo[i] = template[i].type;
            }
            int rv = this.C_GetAttributeValueSize(this.handle, object, templateInfo);
            if (rv != 0) {
                return rv;
            }
            for (int i = 0; i < template.length; ++i) {
                CK_ATTRIBUTE a;
                a = template[i];
                if (CK_ATTRIBUTE.isBool(a.type) || CK_ATTRIBUTE.isInt(a.type)) continue;
                int size = templateInfo[i];
                a.value = new byte[size];
            }
        }
        return this.C_GetAttributeValueData(this.handle, object, template);
    }

    public void generateRandom(byte[] out, int outOffset, int outLen) throws CKException {
        int rv = this.C_GenerateRandom(out, outOffset, outLen);
        if (rv != 0) {
            throw new CKException("C_GenerateRandom", rv);
        }
    }

    public void encryptInit(CK_MECHANISM mechanism, CKKey key) throws CKException {
        int rv = this.C_EncryptInit(mechanism, key.handle);
        if (rv != 0) {
            throw new CKException("C_EncryptInit", rv);
        }
    }

    public void decryptInit(CK_MECHANISM mechanism, CKKey key) throws CKException {
        int rv = this.C_DecryptInit(mechanism, key.handle);
        if (rv != 0) {
            throw new CKException("C_DecryptInit", rv);
        }
    }

    public void signInit(CK_MECHANISM mechanism, CKKey key) throws CKException {
        int rv = this.C_SignInit(mechanism, key.handle);
        if (rv != 0) {
            throw new CKException("C_SignInit", rv);
        }
    }

    public void verifyInit(CK_MECHANISM mechanism, CKKey key) throws CKException {
        int rv = this.C_VerifyInit(mechanism, key.handle);
        if (rv != 0) {
            throw new CKException("C_VerifyInit", rv);
        }
    }

    public int encryptUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws CKException {
        long rvLong = this.C_EncryptUpdate(in, inOffset, inLen, out, outOffset);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_EncryptUpdate", rv);
        }
        return Library.rvValue(rvLong);
    }

    public int decryptUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws CKException {
        long rvLong = this.C_DecryptUpdate(in, inOffset, inLen, out, outOffset);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_DecryptUpdate", rv);
        }
        return Library.rvValue(rvLong);
    }

    public void signUpdate(byte[] in, int inOffset, int inLen) throws CKException {
        int rv = this.C_SignUpdate(in, inOffset, inLen);
        if (rv != 0) {
            throw new CKException("C_SignUpdate", rv);
        }
    }

    public void verifyUpdate(byte[] in, int inOffset, int inLen) throws CKException {
        int rv = this.C_VerifyUpdate(in, inOffset, inLen);
        if (rv != 0) {
            throw new CKException("C_VerifyUpdate", rv);
        }
    }

    public int encryptFinal(byte[] out, int outOffset) throws CKException {
        long rvLong = this.C_EncryptFinal(out, outOffset);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_EncryptFinal", rv);
        }
        return Library.rvValue(rvLong);
    }

    public int decryptFinal(byte[] out, int outOffset) throws CKException {
        long rvLong = this.C_DecryptFinal(out, outOffset);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_DecryptFinal", rv);
        }
        return Library.rvValue(rvLong);
    }

    public byte[] signFinal(int outLen) throws CKException {
        byte[] out;
        long rvLong;
        int rv;
        if (outLen == 0) {
            long rvLong2 = this.C_SignFinal(null);
            int rv2 = Library.rvErr(rvLong2);
            if (rv2 != 0) {
                throw new CKException("C_SignFinal", rv2);
            }
            outLen = Library.rvValue(rvLong2);
        }
        if ((rv = Library.rvErr(rvLong = this.C_SignFinal(out = new byte[outLen]))) != 0) {
            throw new CKException("C_SignFinal", rv);
        }
        outLen = Library.rvValue(rvLong);
        if (outLen == out.length) {
            return out;
        }
        return Arrays.copyOf(out, outLen);
    }

    public boolean verifyFinal(byte[] signature) {
        return 0 == this.C_VerifyFinal(signature);
    }

    public int encrypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws CKException {
        long rvLong = this.C_Encrypt(in, inOffset, inLen, out, outOffset);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_Encrypt", rv);
        }
        return Library.rvValue(rvLong);
    }

    public int decrypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws CKException {
        long rvLong = this.C_Decrypt(in, inOffset, inLen, out, outOffset);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_Decrypt", rv);
        }
        return Library.rvValue(rvLong);
    }

    public byte[] encrypt(byte[] in, int outLen) throws CKException {
        byte[] out;
        if (outLen == 0) {
            outLen = this.encrypt(in, 0, in.length, null, 0);
        }
        if ((outLen = this.encrypt(in, 0, in.length, out = new byte[outLen], 0)) == out.length) {
            return out;
        }
        return Arrays.copyOf(out, outLen);
    }

    public byte[] decrypt(byte[] in, int outLen) throws CKException {
        byte[] out;
        if (outLen == 0) {
            outLen = this.decrypt(in, 0, in.length, null, 0);
        }
        if ((outLen = this.decrypt(in, 0, in.length, out = new byte[outLen], 0)) == out.length) {
            return out;
        }
        return Arrays.copyOf(out, outLen);
    }

    public byte[] sign(byte[] in, int outLen) throws CKException {
        return this.sign(in, 0, in.length, outLen);
    }

    public byte[] sign(byte[] in, int inOffset, int inLen, int outLen) throws CKException {
        byte[] out;
        long rvLong;
        int rv;
        if (outLen == 0) {
            long rvLong2 = this.C_Sign(in, 0, in.length, null);
            int rv2 = Library.rvErr(rvLong2);
            if (rv2 != 0) {
                throw new CKException("C_Sign", rv2);
            }
            outLen = Library.rvValue(rvLong2);
        }
        if ((rv = Library.rvErr(rvLong = this.C_Sign(in, inOffset, inLen, out = new byte[outLen]))) != 0) {
            throw new CKException("C_Sign", rv);
        }
        outLen = Library.rvValue(rvLong);
        if (outLen == out.length) {
            return out;
        }
        return Arrays.copyOf(out, outLen);
    }

    public boolean verify(byte[] in, byte[] signature) throws CKException {
        int rv = this.C_Verify(in, 0, in.length, signature);
        if (rv == 0) {
            return true;
        }
        if (rv == 192) {
            return false;
        }
        throw new CKException("C_Verify", rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encrypt(CK_MECHANISM mechanism, CKKey key, byte[] in, int outLen) throws CKException {
        Session session = key.slot.getSession();
        try {
            session.encryptInit(mechanism, key);
            byte[] byArray = session.encrypt(in, outLen);
            return byArray;
        }
        finally {
            key.slot.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decrypt(CK_MECHANISM mechanism, CKKey key, byte[] in, int outLen) throws CKException {
        Session session = key.slot.getSession();
        try {
            session.decryptInit(mechanism, key);
            byte[] byArray = session.decrypt(in, outLen);
            return byArray;
        }
        finally {
            key.slot.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sign(CK_MECHANISM mechanism, CKKey key, byte[] in, int outLen) throws CKException {
        Session session = key.slot.getSession();
        try {
            session.signInit(mechanism, key);
            byte[] byArray = session.sign(in, outLen);
            return byArray;
        }
        finally {
            key.slot.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(CK_MECHANISM mechanism, CKKey key, byte[] in, byte[] signature) throws CKException {
        Session session = key.slot.getSession();
        try {
            session.verifyInit(mechanism, key);
            boolean bl = session.verify(in, signature);
            return bl;
        }
        finally {
            key.slot.releaseSession(session);
        }
    }

    public byte[] wrap(CK_MECHANISM mechanism, CKKey key, CKKey wrappedKey, int outLen) throws CKException {
        byte[] out;
        long rvLong;
        int rv;
        if (outLen == 0) {
            long rvLong2 = this.C_WrapKey(mechanism, key.handle, wrappedKey.handle, null, 0);
            int rv2 = Library.rvErr(rvLong2);
            if (rv2 != 0) {
                throw new CKException("C_WrapKey", rv2);
            }
            outLen = Library.rvValue(rvLong2);
        }
        if ((rv = Library.rvErr(rvLong = this.C_WrapKey(mechanism, key.handle, wrappedKey.handle, out = new byte[outLen], 0))) != 0) {
            throw new CKException("C_WrapKey", rv);
        }
        outLen = Library.rvValue(rvLong);
        if (outLen == out.length) {
            return out;
        }
        return Arrays.copyOf(out, outLen);
    }
}

