/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.DER;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.ECPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.util.Arrays;

public class ECDSASignature
extends SignatureSpi {
    private int mechanismType;
    protected ECPrivateKey prvKey = null;
    protected Signature pubSignature = null;
    protected Session session = null;
    private final byte[] buffer = new byte[64];
    private int bufferOffset = 0;

    protected ECDSASignature(int mechanismType) {
        this.mechanismType = mechanismType;
    }

    static String mechanismTypeToHashName(int mechanismType) throws InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 4161: {
                return "NONE";
            }
            case 4162: {
                return "SHA1";
            }
            case 4164: {
                return "SHA256";
            }
            case 4165: {
                return "SHA384";
            }
            case 4166: {
                return "SHA512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm: " + mechanismType);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof ECPublicKey) {
            publicKey = ((ECPublicKey)publicKey).getSoftwareKey();
        } else if (!(publicKey instanceof java.security.interfaces.ECPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        try {
            this.pubSignature = Signature.getInstance(ECDSASignature.mechanismTypeToHashName(this.mechanismType) + "withECDSA", "SunEC");
        }
        catch (Exception e) {
            throw new InvalidKeyException("engineInitVerify failed");
        }
        this.pubSignature.initVerify(publicKey);
    }

    protected void checkInit() {
        if (this.session != null) {
            return;
        }
        this.bufferOffset = 0;
        try {
            this.session = this.prvKey.pkcs11Key.signInit(new CK_MECHANISM(this.mechanismType));
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (ECPrivateKey)privateKey;
        try {
            this.prvKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        this.closeSession();
        this.checkInit();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(b);
            return;
        }
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(in, inOffset, inLen);
            return;
        }
        this.checkInit();
        if (this.mechanismType == 4161) {
            if (this.bufferOffset + inLen >= this.buffer.length) {
                throw new SignatureException("Invalid input length");
            }
            System.arraycopy(in, inOffset, this.buffer, this.bufferOffset, inLen);
            this.bufferOffset += inLen;
        } else {
            try {
                this.session.signUpdate(in, inOffset, inLen);
            }
            catch (CKException e) {
                throw new SignatureException(e);
            }
        }
    }

    private static byte[] encodeSignature(byte[] signature) {
        int n = signature.length / 2;
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(signature, 0, n));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signature, n, n * 2));
        return DER.encode((byte)48, DER.cat(DER.encode(r), DER.encode(s)));
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            int size = this.prvKey.pkcs11Key.getCurve().getSize() * 2;
            byte[] signature = this.mechanismType == 4161 ? this.session.sign(this.buffer, 0, this.bufferOffset, size) : this.session.signFinal(size);
            byte[] byArray = ECDSASignature.encodeSignature(signature);
            return byArray;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pubSignature.verify(sigBytes);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
    }

    public static final class SHA512
    extends ECDSASignature {
        public SHA512() {
            super(4166);
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public SHA384() {
            super(4165);
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public SHA256() {
            super(4164);
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public SHA1() {
            super(4162);
        }
    }

    public static final class Raw
    extends ECDSASignature {
        public Raw() {
            super(4161);
        }
    }
}

