/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.ECCurve;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.ECPublicKey;
import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private KeyParameters keyParams = null;
    private ECCurve curve = null;

    @Override
    public void initialize(int keySize, SecureRandom random) {
        this.curve = ECCurve.find(keySize);
        if (this.curve == null) {
            throw new InvalidParameterException("Unsupported EC key size " + keySize);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        ECParameterSpec spec = null;
        KeyGenSpec keyGenSpec = null;
        if (params instanceof KeyGenSpec) {
            keyGenSpec = (KeyGenSpec)params;
            params = keyGenSpec.original;
            this.keyParams = keyGenSpec.params;
            if (params == null) {
                this.initialize(keyGenSpec.bitSize, random);
                return;
            }
        }
        if (params instanceof ECParameterSpec) {
            spec = (ECParameterSpec)params;
        } else if (params instanceof ECGenParameterSpec) {
            try {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                parameters.init((ECGenParameterSpec)params);
                spec = parameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("Unsupported EC curve", e);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        this.curve = ECCurve.find(spec);
        if (this.curve == null) {
            throw new InvalidAlgorithmParameterException("Unsupported EC curve");
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        ECPublicKey pubKey = new ECPublicKey();
        ECPrivateKey prvKey = null;
        try {
            prvKey = new ECPrivateKey().initForGenerate(this.keyParams, pubKey, this.curve);
        }
        catch (Exception e) {
            return null;
        }
        return new KeyPair(pubKey, prvKey);
    }
}

