/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.EDDSAPrivateKey;
import com.dyadicsec.provider.EDDSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class EDDSASignature
extends SignatureSpi {
    protected Session session = null;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    int mechanismType;

    EDDSASignature(int mechanismType) {
        this.mechanismType = mechanismType;
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
    }

    private void checkInit() throws SignatureException {
        if (this.session == null) {
            throw new SignatureException();
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof EDDSAPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        EDDSAPrivateKey eddsaPrivateKey = (EDDSAPrivateKey)privateKey;
        try {
            eddsaPrivateKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        this.closeSession();
        try {
            this.session = eddsaPrivateKey.pkcs11Key.signInit(new CK_MECHANISM(this.mechanismType));
        }
        catch (CKException e) {
            throw new InvalidKeyException(e);
        }
        this.buffer.reset();
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.checkInit();
        try {
            byte[] byArray = this.session.sign(this.buffer.toByteArray(), 0);
            return byArray;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof EDDSAPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.closeSession();
        try {
            this.session = ((EDDSAPublicKey)publicKey).pkcs11Key.verifyInit(new CK_MECHANISM(this.mechanismType));
        }
        catch (CKException e) {
            throw new InvalidKeyException(e);
        }
        if (this.buffer == null) {
            this.buffer = new ByteArrayOutputStream();
        } else {
            this.buffer.reset();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        this.checkInit();
        try {
            boolean bl = this.session.verify(this.buffer.toByteArray(), sigBytes);
            return bl;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        this.checkInit();
        this.buffer.write(in, inOffset, inLen);
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    public static final class Raw
    extends EDDSASignature {
        public Raw() {
            super(-2147451263);
        }
    }
}

