/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKLIMAPrivateKey;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.provider.DYKey;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.KeyStore;
import com.dyadicsec.provider.LIMAPublicKey;
import java.security.KeyStoreException;
import java.security.PrivateKey;

public class LIMAPrivateKey
extends DYKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    KeyParameters keyParams = null;
    private LIMAPublicKey genPublicKey = null;
    CKLIMAPrivateKey pkcs11Key = null;

    LIMAPrivateKey() {
    }

    LIMAPrivateKey(CKLIMAPrivateKey pkcs11Key) {
        this.pkcs11Key = pkcs11Key;
    }

    @Override
    protected CKPrivateKey getPkcs11Key() {
        return this.pkcs11Key;
    }

    LIMAPrivateKey initForGenerate(KeyParameters keyParams, LIMAPublicKey genPublicKey) {
        this.keyParams = keyParams;
        this.genPublicKey = genPublicKey;
        genPublicKey.prvKey = this;
        return this;
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKLIMAPrivateKey.generate(store.slot, alias, KeyParameters.toPolicy(this.keyParams));
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
        if (this.genPublicKey != null) {
            try {
                this.genPublicKey.pkcs11Key = this.pkcs11Key.getPublicKey();
            }
            catch (Throwable e) {
                throw new KeyStoreException(e);
            }
        }
    }

    public LIMAPublicKey getPublicKey() throws KeyStoreException {
        if (this.genPublicKey == null && this.pkcs11Key != null) {
            try {
                this.genPublicKey = new LIMAPublicKey(this.pkcs11Key.getPublicKey());
            }
            catch (CKException e) {
                throw new KeyStoreException(e);
            }
        }
        return this.genPublicKey;
    }

    @Override
    public String getAlgorithm() {
        return "LIMA";
    }

    @Override
    public String getFormat() {
        return "N/A";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }
}

