/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.pkcs11.CKRSAPrivateKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.Utils;
import com.dyadicsec.provider.DYKey;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.KeyStore;
import com.dyadicsec.provider.RSAPublicKey;
import com.dyadicsec.provider.UnwrapInfo;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public final class RSAPrivateKey
extends DYKey
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = 1L;
    private RSAPrivateCrtKey sw = null;
    CKRSAPrivateKey pkcs11Key = null;
    private UnwrapInfo unwrapInfo = null;
    KeyParameters keyParams = null;
    private RSAPublicKey genPublicKey = null;
    private int bitSize = 0;

    RSAPrivateKey() {
    }

    RSAPrivateKey(CKRSAPrivateKey pkcs11Key) {
        this.pkcs11Key = pkcs11Key;
    }

    @Override
    protected CKPrivateKey getPkcs11Key() {
        return this.pkcs11Key;
    }

    @Override
    protected void unwrap(String alias) throws KeyStoreException {
        CK_ATTRIBUTE[] t = CKRSAPrivateKey.getUnwrapTemplate(alias, KeyParameters.toPolicy(this.keyParams));
        this.pkcs11Key = this.unwrapInfo.unwrap(CKRSAPrivateKey.class, t);
        this.unwrapInfo = null;
    }

    @Override
    protected void create(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKRSAPrivateKey.create(store.slot, alias, KeyParameters.toPolicy(this.keyParams), this.sw.getModulus(), this.sw.getPublicExponent(), this.sw.getPrivateExponent(), this.sw.getPrimeP(), this.sw.getPrimeQ(), this.sw.getPrimeExponentP(), this.sw.getPrimeExponentQ(), this.sw.getCrtCoefficient());
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKRSAPrivateKey.generate(store.slot, alias, KeyParameters.toPolicy(this.keyParams), this.bitSize);
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
        if (this.genPublicKey != null) {
            try {
                this.genPublicKey.init(this.pkcs11Key.getN(), this.pkcs11Key.getE());
            }
            catch (Throwable e) {
                throw new KeyStoreException(e);
            }
        }
    }

    @Override
    protected boolean swKeyPresent() {
        return this.sw != null;
    }

    @Override
    protected boolean unwrapInfoPresent() {
        return this.unwrapInfo != null;
    }

    RSAPrivateKey initForUnwrap(UnwrapInfo unwrapInfo) {
        this.unwrapInfo = unwrapInfo;
        return this;
    }

    RSAPrivateKey initForImport(KeyParameters keyParams, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf;
        this.keyParams = keyParams;
        try {
            kf = KeyFactory.getInstance("RSA", "SunRsaSign");
        }
        catch (NoSuchProviderException e) {
            kf = null;
        }
        catch (NoSuchAlgorithmException e) {
            kf = null;
        }
        if (kf == null) {
            try {
                kf = KeyFactory.getInstance("RSA", "IBMJCE");
            }
            catch (NoSuchProviderException e) {
                kf = null;
            }
            catch (NoSuchAlgorithmException e) {
                kf = null;
            }
        }
        if (kf == null) {
            kf = KeyFactory.getInstance("RSA", "IBMJSSE2");
        }
        this.sw = (RSAPrivateCrtKey)kf.generatePrivate(keySpec);
        return this;
    }

    RSAPrivateKey initForImport(RSAPrivateCrtKey key) {
        this.sw = key;
        return this;
    }

    RSAPrivateKey initForGenerate(KeyParameters keyParams, RSAPublicKey genPublicKey, int genBitSize) {
        this.keyParams = keyParams;
        this.genPublicKey = genPublicKey;
        this.bitSize = genBitSize;
        genPublicKey.prvKey = this;
        return this;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.sw != null ? this.sw.getPrivateExponent() : null;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return this.sw != null ? this.sw.getFormat() : "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.sw != null ? this.sw.getEncoded() : null;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.sw != null ? this.sw.getPrimeP() : null;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.sw != null ? this.sw.getPrimeQ() : null;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.sw != null ? this.sw.getPrimeExponentP() : null;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.sw != null ? this.sw.getPrimeExponentQ() : null;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.sw != null ? this.sw.getCrtCoefficient() : null;
    }

    @Override
    public BigInteger getModulus() {
        if (this.sw != null) {
            return this.sw.getModulus();
        }
        if (this.pkcs11Key != null) {
            try {
                return this.pkcs11Key.getN();
            }
            catch (CKException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public BigInteger getPublicExponent() {
        if (this.sw != null) {
            return this.sw.getPublicExponent();
        }
        if (this.pkcs11Key != null) {
            try {
                return this.pkcs11Key.getE();
            }
            catch (CKException e) {
                return null;
            }
        }
        return null;
    }

    int getBitSize() throws KeyStoreException {
        if (this.bitSize == 0) {
            if (this.sw != null) {
                this.bitSize = Utils.bigIntByteSize(this.sw.getModulus()) * 8;
            } else if (this.pkcs11Key != null) {
                try {
                    this.bitSize = this.pkcs11Key.getBitSize();
                }
                catch (CKException e) {
                    throw new KeyStoreException(e);
                }
            }
        }
        return this.bitSize;
    }
}

