/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKRSAPublicKey;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Utils;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.KeyStore;
import com.dyadicsec.provider.RSAPrivateKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;

public final class RSAPublicKey
implements java.security.interfaces.RSAPublicKey {
    private static final long serialVersionUID = 1L;
    private java.security.interfaces.RSAPublicKey sw = null;
    RSAPrivateKey prvKey = null;

    RSAPublicKey() {
    }

    RSAPublicKey(KeySpec keySpec, KeyParameters keyParams) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.init(keySpec);
    }

    RSAPublicKey(java.security.interfaces.RSAPublicKey key) {
        this.sw = key;
    }

    private void init(KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf = null;
        try {
            kf = KeyFactory.getInstance("RSA", "SunRsaSign");
        }
        catch (NoSuchProviderException e) {
            kf = null;
        }
        catch (NoSuchAlgorithmException e) {
            kf = null;
        }
        if (kf == null) {
            try {
                kf = KeyFactory.getInstance("RSA", "IBMJCE");
            }
            catch (NoSuchProviderException e) {
                kf = null;
            }
            catch (NoSuchAlgorithmException e) {
                kf = null;
            }
        }
        if (kf == null) {
            kf = KeyFactory.getInstance("RSA", "IBMJSSE2");
        }
        this.sw = (java.security.interfaces.RSAPublicKey)kf.generatePublic(keySpec);
    }

    void init(BigInteger N, BigInteger E) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.init(new RSAPublicKeySpec(N, E));
    }

    @Override
    public BigInteger getModulus() {
        return this.getSoftwareKey().getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.getSoftwareKey().getPublicExponent();
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return this.getSoftwareKey().getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.getSoftwareKey().getEncoded();
    }

    int getBitSize() {
        return Utils.bigIntByteSize(this.getModulus()) * 8;
    }

    java.security.interfaces.RSAPublicKey getSoftwareKey() {
        if (this.sw != null) {
            return this.sw;
        }
        if (this.prvKey != null) {
            try {
                this.prvKey.save();
            }
            catch (KeyStoreException e) {
                return null;
            }
        }
        return this.sw;
    }

    void createTrusted(KeyStore store, String alias) throws KeyStoreException {
        BigInteger E = this.sw.getPublicExponent();
        BigInteger N = this.sw.getModulus();
        Policy policy = new Policy();
        policy.setTrusted(true);
        try {
            CKRSAPublicKey.create(store.slot, alias, policy, N, E);
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }
}

