/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.RSAPrivateKey;
import com.dyadicsec.provider.RSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class RSASignature
extends SignatureSpi {
    private int mechanismType;
    private RSAPrivateKey prvKey = null;
    private Signature pubSignature = null;
    private Session session = null;
    private ByteArrayOutputStream buffer = null;

    static String getSunProvider(int mechanismType) throws InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 1: {
                return "SunJCE";
            }
            case 6: {
                return "SunRsaSign";
            }
            case 64: {
                return "SunRsaSign";
            }
            case 65: {
                return "SunRsaSign";
            }
            case 66: {
                return "SunRsaSign";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm: " + mechanismType);
    }

    static String mechanismTypeToHashName(int mechanismType) throws InvalidAlgorithmParameterException {
        switch (mechanismType) {
            case 1: {
                return "NONE";
            }
            case 6: {
                return "SHA1";
            }
            case 64: {
                return "SHA256";
            }
            case 65: {
                return "SHA384";
            }
            case 66: {
                return "SHA512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm: " + mechanismType);
    }

    RSASignature(int mechanismType) {
        this.mechanismType = mechanismType;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            publicKey = ((RSAPublicKey)publicKey).getSoftwareKey();
        } else if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        try {
            this.pubSignature = Signature.getInstance(RSASignature.mechanismTypeToHashName(this.mechanismType) + "WithRSA", RSASignature.getSunProvider(this.mechanismType));
        }
        catch (Throwable e) {
            throw new InvalidKeyException("engineInitVerify failed");
        }
        this.pubSignature.initVerify(publicKey);
    }

    private void checkInit() {
        if (this.session != null) {
            return;
        }
        try {
            this.session = this.prvKey.pkcs11Key.signInit(new CK_MECHANISM(this.mechanismType));
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
        if (this.mechanismType == 1) {
            if (this.buffer == null) {
                this.buffer = new ByteArrayOutputStream();
            }
            this.buffer.reset();
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (RSAPrivateKey)privateKey;
        try {
            this.prvKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        this.closeSession();
        this.checkInit();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(b);
            return;
        }
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(in, inOffset, inLen);
            return;
        }
        this.checkInit();
        if (this.mechanismType == 1) {
            this.buffer.write(in, inOffset, inLen);
        } else {
            try {
                this.session.signUpdate(in, inOffset, inLen);
            }
            catch (CKException e) {
                throw new SignatureException(e);
            }
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.checkInit();
        try {
            int size = this.prvKey.pkcs11Key.getBitSize();
            byte[] result = this.mechanismType == 1 ? this.session.sign(this.buffer.toByteArray(), size) : this.session.signFinal(size);
            byte[] byArray = result;
            return byArray;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pubSignature.verify(sigBytes);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
    }

    public static final class SHA512withRSA
    extends RSASignature {
        public SHA512withRSA() {
            super(66);
        }
    }

    public static final class SHA384withRSA
    extends RSASignature {
        public SHA384withRSA() {
            super(65);
        }
    }

    public static final class SHA256withRSA
    extends RSASignature {
        public SHA256withRSA() {
            super(64);
        }
    }

    public static final class SHA1withRSA
    extends RSASignature {
        public SHA1withRSA() {
            super(6);
        }
    }

    public static final class NONEwithRSA
    extends RSASignature {
        public NONEwithRSA() {
            super(1);
        }
    }
}

