/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKECPublicKey;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.ECCurve;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.provider.DYCryptoProvider;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.ECPublicKey;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class SchnorrSignature
extends SignatureSpi {
    private final int mechanismType = -2147451248;
    protected ECPrivateKey prvKey = null;
    protected Session session = null;
    private final byte[] buffer = new byte[32];
    private int bufferOffset = 0;

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        java.security.interfaces.ECPublicKey sunPubKey = null;
        if (publicKey instanceof ECPublicKey) {
            sunPubKey = ((ECPublicKey)publicKey).getSoftwareKey();
        } else if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            sunPubKey = (java.security.interfaces.ECPublicKey)publicKey;
        } else {
            throw new InvalidKeyException("Invalid key type");
        }
        this.closeSession();
        try {
            Slot slot = DYCryptoProvider.getDefaultKeyStore().getSlot();
            CKECPublicKey pkcsPubKey = CKECPublicKey.create(slot, null, null, ECCurve.find("secp256k1"), sunPubKey.getW());
            this.session = pkcsPubKey.verifyInit(new CK_MECHANISM(-2147451248));
        }
        catch (CKException e) {
            throw new InvalidKeyException(e);
        }
    }

    protected void checkInit() {
        if (this.session != null) {
            return;
        }
        this.bufferOffset = 0;
        try {
            this.session = this.prvKey.pkcs11Key.signInit(new CK_MECHANISM(-2147451248));
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (ECPrivateKey)privateKey;
        try {
            this.prvKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        this.closeSession();
        this.checkInit();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        this.checkInit();
        if (this.bufferOffset + inLen > this.buffer.length) {
            throw new SignatureException("Invalid input length");
        }
        System.arraycopy(in, inOffset, this.buffer, this.bufferOffset, inLen);
        this.bufferOffset += inLen;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.session.sign(this.buffer, 0, this.bufferOffset, 64);
            return byArray;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            boolean bl = this.session.verify(this.buffer, sigBytes);
            return bl;
        }
        catch (CKException e) {
            throw new SignatureException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
        this.bufferOffset = 0;
    }
}

