/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CK_CCM_PARAMS;
import com.dyadicsec.pkcs11.CK_GCM_PARAMS;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.DYCK_AES_SIV_PARAMS;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.provider.CCMParameterSpec;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.RSAPrivateKey;
import com.dyadicsec.provider.SecretKey;
import com.dyadicsec.provider.UnwrapInfo;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class SecretKeyCipher
extends CipherSpi {
    private SecretKey secretKey = null;
    private final int keyType;
    private boolean wrap = false;
    private boolean encrypt = true;
    private boolean singleOp = false;
    private AlgorithmParameterSpec paramSpec = null;
    private boolean aad = false;
    private boolean padding = false;
    private boolean initialized = false;
    private byte[] buffer = null;
    private byte[] auth = null;
    private LinkedList<byte[]> siv_headers = null;
    private Session session = null;
    private CK_MECHANISM mechanism = null;
    private int mode = 0;
    private static final int ECB = 1;
    private static final int CBC = 2;
    private static final int CCM = 3;
    private static final int GCM = 4;
    private static final int OFB = 5;
    private static final int CFB = 6;
    private static final int CTR = 7;
    private static final int XTS = 8;
    private static final int SIV = 9;
    private static final int NIST = 10;
    private static final byte[] B0 = new byte[0];

    SecretKeyCipher(int keyType) {
        this.keyType = keyType;
    }

    private void checkValidAlg(int keyType) throws NoSuchAlgorithmException {
        if (this.keyType != keyType) {
            throw new NoSuchAlgorithmException("Mode not supported");
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if ((mode = mode.toUpperCase()).equalsIgnoreCase("CCM")) {
            this.mode = 3;
            this.checkValidAlg(31);
            this.aad = true;
        } else if (mode.equalsIgnoreCase("GCM")) {
            this.mode = 4;
            this.checkValidAlg(31);
            this.aad = true;
        } else if (mode.equalsIgnoreCase("ECB")) {
            this.mode = 1;
        } else if (mode.equalsIgnoreCase("CBC")) {
            this.mode = 2;
        } else if (mode.equalsIgnoreCase("CTR")) {
            this.mode = 7;
            this.checkValidAlg(31);
        } else if (mode.equalsIgnoreCase("OFB64")) {
            this.mode = 5;
            this.checkValidAlg(21);
        } else if (mode.equalsIgnoreCase("OFB128")) {
            this.mode = 5;
            this.checkValidAlg(31);
        } else if (mode.equalsIgnoreCase("CFB64")) {
            this.mode = 6;
            this.checkValidAlg(21);
        } else if (mode.equalsIgnoreCase("CFB128")) {
            this.mode = 6;
            this.checkValidAlg(31);
        } else if (mode.equalsIgnoreCase("XTS")) {
            this.mode = 8;
            this.checkValidAlg(-2147454715);
            this.singleOp = true;
        } else if (mode.equalsIgnoreCase("SIV")) {
            this.mode = 9;
            this.checkValidAlg(-2147454716);
            this.singleOp = true;
            this.aad = true;
        } else if (mode.equalsIgnoreCase("WRAP")) {
            this.mode = 10;
            this.checkValidAlg(31);
            this.singleOp = true;
        } else {
            throw new NoSuchAlgorithmException("Mode not supported: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("NOPADDING")) {
            this.padding = false;
        } else if (padding.equalsIgnoreCase("PKCS5PADDING")) {
            if (this.mode != 2 && this.mode != 10) {
                throw new NoSuchPaddingException("padding not supported");
            }
            this.padding = true;
        } else {
            throw new NoSuchPaddingException("padding not supported");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.keyType == 21 ? 8 : 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        byte[] temp = new byte[(this.singleOp ? this.buffer.length : 0) + inputLen];
        return this.encdecLen(temp, 0, temp.length);
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.paramSpec == null) {
            return null;
        }
        if (this.paramSpec instanceof IvParameterSpec) {
            return ((IvParameterSpec)this.paramSpec).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key;
            try {
                return secretKey.getBitSize();
            }
            catch (KeyStoreException e) {
                throw new InvalidKeyException(e);
            }
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Invalid key value");
        }
        return encoded.length * 8;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.paramSpec == null) {
            return null;
        }
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance(this.keyType == 21 ? "DESede" : "AES", "SunJCE");
            params.init(this.paramSpec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not encode parameters", e);
        }
    }

    private int getMechanismType() {
        switch (this.mode) {
            case 7: {
                return 4230;
            }
            case 4: {
                return 4231;
            }
            case 3: {
                return 4232;
            }
            case 8: {
                return -2147451327;
            }
            case 9: {
                return -2147451391;
            }
            case 10: {
                return this.padding ? 8458 : 8457;
            }
            case 5: {
                return this.keyType == 31 ? 8452 : 336;
            }
            case 6: {
                return this.keyType == 31 ? 8455 : 338;
            }
            case 1: {
                return this.keyType == 31 ? 4225 : 306;
            }
            case 2: {
                return this.padding ? (this.keyType == 31 ? 4229 : 310) : (this.keyType == 31 ? 4226 : 307);
            }
        }
        return -1;
    }

    private CK_MECHANISM getMechIV(IvParameterSpec spec) {
        int mechanismType = this.getMechanismType();
        if (this.mechanism != null && this.mechanism.getType() == mechanismType) {
            this.mechanism.setBuffer(spec.getIV());
            return this.mechanism;
        }
        return new CK_MECHANISM(mechanismType, spec.getIV());
    }

    private CK_MECHANISM getMechSIV() {
        return new DYCK_AES_SIV_PARAMS(this.siv_headers == null ? (byte[][])null : (byte[][])this.siv_headers.toArray());
    }

    private CK_MECHANISM getMechGCM(GCMParameterSpec spec) {
        if (this.mechanism != null && this.mechanism.getType() == 4231) {
            ((CK_GCM_PARAMS)this.mechanism).init(spec.getIV(), this.auth, spec.getTLen());
            return this.mechanism;
        }
        return new CK_GCM_PARAMS(spec.getIV(), this.auth, spec.getTLen());
    }

    private CK_MECHANISM getMechCCM(CCMParameterSpec spec) {
        return new CK_CCM_PARAMS(spec.getDataSize(), spec.getIV(), this.auth, spec.getTagSize());
    }

    private void ensureInitOperation() {
        try {
            this.ensureInit();
        }
        catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ProviderException(e);
        }
    }

    private void initSession() throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.session = this.encrypt ? this.secretKey.pkcs11Key.encryptInit(this.mechanism) : this.secretKey.pkcs11Key.decryptInit(this.mechanism);
        }
        catch (CKException e) {
            if (e.getRV() == 7 || e.getRV() == 112 || e.getRV() == 113) {
                throw new InvalidAlgorithmParameterException(e);
            }
            throw new InvalidKeyException(e);
        }
    }

    private void releaseSession() {
        if (this.session == null) {
            return;
        }
        this.secretKey.pkcs11Key.getSlot().releaseSession(this.session);
        this.session = null;
    }

    private void prepareMechanism() throws InvalidAlgorithmParameterException {
        this.mechanism = null;
        switch (this.mode) {
            case 9: {
                this.mechanism = this.getMechSIV();
                break;
            }
            case 4: {
                this.mechanism = this.getMechGCM((GCMParameterSpec)this.paramSpec);
                break;
            }
            case 3: {
                this.mechanism = this.getMechCCM((CCMParameterSpec)this.paramSpec);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                this.mechanism = this.getMechIV((IvParameterSpec)this.paramSpec);
                break;
            }
            case 1: {
                this.mechanism = new CK_MECHANISM(this.getMechanismType());
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Invalid PKCS#11 mechanism");
            }
        }
    }

    private void ensureInit() throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.initialized) {
            return;
        }
        this.buffer = null;
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
        this.prepareMechanism();
        if (!this.wrap) {
            this.initSession();
        }
        if (this.singleOp) {
            this.buffer = B0;
        }
        if (this.aad) {
            this.auth = B0;
        }
        this.initialized = true;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initialized = false;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.secretKey = (SecretKey)key;
        try {
            this.secretKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        try {
            if (this.secretKey.getKeyType() != this.keyType) {
                throw new InvalidKeyException("Invalid key type");
            }
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        this.wrap = opmode == 3 || opmode == 4;
        this.encrypt = opmode == 1 || opmode == 3;
        this.paramSpec = algorithmParameterSpec;
        switch (this.mode) {
            case 9: {
                if (this.wrap) break;
                throw new InvalidAlgorithmParameterException("SIV doesn't support encrypt/decrypt");
            }
            case 4: {
                if (this.paramSpec instanceof GCMParameterSpec) break;
                throw new InvalidAlgorithmParameterException("GCMParameterSpec required");
            }
            case 3: {
                if (this.paramSpec instanceof CCMParameterSpec) break;
                throw new InvalidAlgorithmParameterException("CCMParameterSpec required");
            }
            case 10: {
                if (this.paramSpec == null) {
                    byte[] iv = new byte[]{};
                    this.paramSpec = new IvParameterSpec(iv);
                    break;
                }
                if (!(this.paramSpec instanceof IvParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("IvParameterSpec required");
                }
                int ivLen = ((IvParameterSpec)this.paramSpec).getIV().length;
                if (ivLen == 8) break;
                throw new InvalidAlgorithmParameterException("Invalid IV length");
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.wrap && this.mode == 8) {
                    throw new InvalidAlgorithmParameterException("XTS doesn't support wrap/unwrap");
                }
                if (this.paramSpec == null && this.encrypt) {
                    if (secureRandom == null) {
                        throw new InvalidAlgorithmParameterException("Can't generate IV");
                    }
                    int size = this.engineGetBlockSize();
                    if (this.mode == 10) {
                        size = 0;
                    }
                    byte[] iv = new byte[size];
                    secureRandom.nextBytes(iv);
                    this.paramSpec = new IvParameterSpec(iv);
                }
                if (this.paramSpec == null || !(this.paramSpec instanceof IvParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("IvParameterSpec required");
                }
                if (((IvParameterSpec)this.paramSpec).getIV().length == this.engineGetBlockSize()) break;
                throw new InvalidAlgorithmParameterException("Invalid IV length");
            }
        }
        if (this.aad) {
            this.auth = B0;
            this.siv_headers = null;
        } else {
            this.ensureInit();
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        Class clazz = IvParameterSpec.class;
        switch (this.mode) {
            case 3: {
                clazz = CCMParameterSpec.class;
                break;
            }
            case 4: {
                clazz = GCMParameterSpec.class;
            }
        }
        if (algorithmParameters != null) {
            try {
                spec = algorithmParameters.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter");
            }
        }
        this.engineInit(opmode, key, spec, secureRandom);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
    }

    private void updateSingleOp(byte[] in, int inOffset, int inLen) {
        int oldSize = this.buffer.length;
        byte[] newBuffer = new byte[oldSize + inLen];
        if (oldSize > 0) {
            System.arraycopy(this.buffer, 0, newBuffer, 0, oldSize);
        }
        System.arraycopy(in, inOffset, newBuffer, oldSize, inLen);
        this.buffer = newBuffer;
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) throws IllegalStateException, UnsupportedOperationException {
        if (!this.aad) {
            throw new IllegalStateException("Cipher does not accept AAD");
        }
        if (this.mode == 9) {
            if (this.siv_headers == null) {
                this.siv_headers = new LinkedList();
            }
            this.siv_headers.add(Arrays.copyOfRange(src, offset, len));
            return;
        }
        int oldSize = this.auth.length;
        byte[] newBuffer = new byte[oldSize + len];
        if (oldSize > 0) {
            System.arraycopy(this.auth, 0, newBuffer, 0, oldSize);
        }
        System.arraycopy(src, offset, newBuffer, oldSize, len);
        this.auth = newBuffer;
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOffset, int inLen) {
        if (inLen == 0 || in == null) {
            return B0;
        }
        this.ensureInitOperation();
        if (this.singleOp) {
            this.updateSingleOp(in, inOffset, inLen);
            return B0;
        }
        int outLen = this.encdecUpdateLen(in, inOffset, inLen);
        byte[] out = new byte[outLen];
        int realOutLen = this.encdecUpdate(in, inOffset, inLen, out, 0);
        if (realOutLen == outLen) {
            return out;
        }
        return Arrays.copyOf(out, realOutLen);
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        if (inLen == 0 || in == null) {
            return 0;
        }
        this.ensureInitOperation();
        if (this.singleOp) {
            this.updateSingleOp(in, inOffset, inLen);
            return 0;
        }
        int outLen = this.encdecUpdateLen(in, inOffset, inLen);
        if (outLen > out.length - outOffset) {
            throw new ShortBufferException();
        }
        return this.encdecUpdate(in, inOffset, inLen, out, outOffset);
    }

    private int getOutBufLen(int inLen) {
        int blockLen = this.keyType == 21 ? 8 : 16;
        return inLen + blockLen * (this.encrypt ? 3 : 1);
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOffset, int inLen) throws IllegalBlockSizeException, BadPaddingException, AEADBadTagException {
        int outLen;
        byte[] out;
        int realOutLen;
        this.ensureInitOperation();
        if (this.singleOp) {
            this.engineUpdate(in, inOffset, inLen);
            in = this.buffer;
            inOffset = 0;
            inLen = this.buffer.length;
        }
        if ((realOutLen = this.encdec(in, inOffset, inLen, out = new byte[(outLen = this.getOutBufLen(inLen)) == 0 ? 1 : outLen], 0)) == outLen) {
            return out;
        }
        return Arrays.copyOf(out, realOutLen);
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, AEADBadTagException {
        int outLen;
        this.ensureInitOperation();
        if (this.singleOp) {
            if (in != null && inLen > 0) {
                this.engineUpdate(in, inOffset, inLen);
            }
            in = this.buffer;
            inOffset = 0;
            inLen = this.buffer.length;
        }
        if ((outLen = this.encdecLen(in, inOffset, inLen)) > out.length - outOffset) {
            throw new ShortBufferException();
        }
        return this.encdec(in, inOffset, inLen, out, outOffset);
    }

    private int encdecLen(byte[] in, int inOffset, int inLen) {
        try {
            return this.encrypt ? this.session.encrypt(in, inOffset, inLen, null, 0) : this.session.decrypt(in, inOffset, inLen, null, 0);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    private int encdec(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException, BadPaddingException, AEADBadTagException {
        try {
            int n = this.encrypt ? this.session.encrypt(in, inOffset, inLen, out, outOffset) : this.session.decrypt(in, inOffset, inLen, out, outOffset);
            return n;
        }
        catch (CKException e) {
            int rv = e.getRV();
            if (rv == 33 || rv == 65) {
                throw new IllegalBlockSizeException();
            }
            if (rv == 32 || rv == 64) {
                if (this.aad) {
                    throw new AEADBadTagException();
                }
                throw new BadPaddingException();
            }
            throw new ProviderException(e);
        }
        finally {
            this.releaseSession();
        }
    }

    private int encdecUpdateLen(byte[] in, int inOffset, int inLen) {
        try {
            return this.encrypt ? this.session.encryptUpdate(in, inOffset, inLen, null, 0) : this.session.decryptUpdate(in, inOffset, inLen, null, 0);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    private int encdecUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        try {
            return this.encrypt ? this.session.encryptUpdate(in, inOffset, inLen, out, outOffset) : this.session.decryptUpdate(in, inOffset, inLen, out, outOffset);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        CKKey wrappedPkcs11Key = null;
        try {
            if (key instanceof SecretKey) {
                ((SecretKey)key).save();
                wrappedPkcs11Key = ((SecretKey)key).pkcs11Key;
            } else if (key instanceof RSAPrivateKey) {
                ((RSAPrivateKey)key).save();
                wrappedPkcs11Key = ((RSAPrivateKey)key).pkcs11Key;
            } else if (key instanceof ECPrivateKey) {
                ((ECPrivateKey)key).save();
                wrappedPkcs11Key = ((ECPrivateKey)key).pkcs11Key;
            }
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
        try {
            this.prepareMechanism();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
        if (wrappedPkcs11Key != null) {
            try {
                return this.secretKey.pkcs11Key.wrap(this.mechanism, wrappedPkcs11Key, 0);
            }
            catch (CKException e) {
                throw new InvalidKeyException(e);
            }
        }
        byte[] encodedKey = key.getEncoded();
        if (encodedKey == null || encodedKey.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        try {
            this.initSession();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ProviderException(e);
        }
        try {
            byte[] e = this.engineDoFinal(encodedKey, 0, encodedKey.length);
            return e;
        }
        catch (BadPaddingException e) {
            throw new ProviderException(e);
        }
        finally {
            this.releaseSession();
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.prepareMechanism();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
        UnwrapInfo unwrapInfo = new UnwrapInfo(this.mechanism, this.secretKey.pkcs11Key, wrappedKey);
        switch (wrappedKeyType) {
            case 2: {
                if (wrappedKeyAlgorithm.equalsIgnoreCase("RSA")) {
                    return new RSAPrivateKey().initForUnwrap(unwrapInfo);
                }
                if (wrappedKeyAlgorithm.equalsIgnoreCase("EC")) {
                    return new ECPrivateKey().initForUnwrap(unwrapInfo);
                }
                throw new InvalidKeyException("Unsupported wrappedKeyAlgorithm " + wrappedKeyAlgorithm);
            }
            case 3: {
                return new SecretKey().initForUnwrap(unwrapInfo, SecretKey.algToKeyType(wrappedKeyAlgorithm));
            }
        }
        throw new InvalidKeyException("Unsupported wrappedKeyType");
    }

    public static final class DES3
    extends SecretKeyCipher {
        public DES3() {
            super(21);
        }
    }

    public static final class AESSIV
    extends SecretKeyCipher {
        public AESSIV() {
            super(-2147454716);
        }
    }

    public static final class AESXTS
    extends SecretKeyCipher {
        public AESXTS() {
            super(-2147454715);
        }
    }

    public static final class AES
    extends SecretKeyCipher {
        public AES() {
            super(31);
        }
    }
}

