/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.provider.KeyGenSpec;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.SecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;

public class SecretKeyGenerator
extends KeyGeneratorSpi {
    private int bitSize = 128;
    private final int keyType;
    KeyParameters keyParams = null;

    SecretKeyGenerator(int keyType) {
        this.keyType = keyType;
        if (keyType == 21) {
            this.bitSize = 192;
        }
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(paramSpec instanceof KeyGenSpec)) {
            throw new InvalidAlgorithmParameterException("AES key generation does not take any parameters");
        }
        KeyGenSpec spec = (KeyGenSpec)paramSpec;
        this.keyParams = spec.params;
        this.engineInit(spec.bitSize, secureRandom);
    }

    @Override
    protected void engineInit(int bitSize, SecureRandom secureRandom) {
        switch (this.keyType) {
            case 31: {
                if (bitSize == 128 || bitSize == 192 || bitSize == 256) break;
                throw new InvalidParameterException("Wrong key size: must be equal to 128, 192 or 256");
            }
            case -2147454716: 
            case -2147454715: {
                if (bitSize == 256 || bitSize == 512) break;
                throw new InvalidParameterException("Wrong key size: must be equal to 256 or 512");
            }
            case 21: {
                if (bitSize == 192) break;
                throw new InvalidParameterException("Wrong key size: must be equal to 192");
            }
        }
        this.bitSize = bitSize;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        return new SecretKey().initForGenerate(this.keyParams, this.keyType, this.bitSize);
    }

    public static final class Hmac
    extends SecretKeyGenerator {
        public Hmac() {
            super(16);
        }
    }

    public static final class DES3
    extends SecretKeyGenerator {
        public DES3() {
            super(21);
        }
    }

    public static final class AESSIV
    extends SecretKeyGenerator {
        public AESSIV() {
            super(-2147454716);
        }
    }

    public static final class AESXTS
    extends SecretKeyGenerator {
        public AESXTS() {
            super(-2147454715);
        }
    }

    public static final class AES
    extends SecretKeyGenerator {
        public AES() {
            super(31);
        }
    }
}

